package jp.kirikiri.tjs2;

import java.util.ArrayList;

public class DictionaryClass extends NativeClass {

	static private final int
		E_MEMBERNOTFOUND = -1001,
		E_NOTIMPL		= -1002,
		E_BADPARAMCOUNT	= -1004,
		E_INVALIDOBJECT	= -1006,
		E_NATIVECLASSCRASH = -1008,
		S_OK			= 0,
		S_TRUE			= 1;
	static private final int
		NIS_GETINSTANCE		= 0x00000002; // get native pointer

	static private int mClassID = -1;

	protected NativeInstance createNativeInstance() {
		return new DictionaryNI();
	}
	protected Dispatch2 createBaseTJSObject() {
		return new DictionaryObject();
	}

	public DictionaryClass() throws VariantException, TJSException {
		super("Dictionary");
		final String __classname = "Dictionary";
		final int NCM_CLASSID = TJS.registerNativeClass(__classname);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		Class<? extends DictionaryClass> c = getClass();
		registerMethods( c, __classname );
		DictionaryNI.ClassID_Dictionary = NCM_CLASSID;
	}
	public static DictionaryNI getNativeInstance( Dispatch2 objthis ) {
		Holder<NativeInstance> holder = new Holder<NativeInstance>(null);
		int hr = objthis.nativeInstanceSupport( NIS_GETINSTANCE, mClassID, holder );
		if( hr < 0 ) return null;
		return (DictionaryNI) holder.mValue;
	}
	@TJSStatic
	public static int constructor( Variant result, Variant[] param, Dispatch2 objthis ) {
		DictionaryNI _this;
		Holder<NativeInstance> holder = new Holder<NativeInstance>(null);
		int hr = objthis.nativeInstanceSupport( NIS_GETINSTANCE, mClassID, holder );
		_this = (DictionaryNI) holder.mValue;
		if( hr < 0 ) return E_NATIVECLASSCRASH;
		if( _this == null ) return E_NATIVECLASSCRASH;
		hr = _this.construct( param, objthis );
		if( hr < 0 ) return hr;

		return S_OK;
	}
	@TJSStatic
	public static int load( Variant result, Variant[] param, Dispatch2 objthis ) {
		DictionaryNI ni = getNativeInstance(objthis);
		if( ni == null ) return E_NATIVECLASSCRASH;
		if( !ni.isValid() ) return E_INVALIDOBJECT;
		// OribinalTODO: implement Dictionary.load()
		return S_OK;
	}
	@TJSStatic
	public static int save( Variant result, Variant[] param, Dispatch2 objthis ) {
		DictionaryNI ni = getNativeInstance(objthis);
		if( ni == null ) return E_NATIVECLASSCRASH;
		if( !ni.isValid() ) return E_INVALIDOBJECT;
		// OribinalTODO: implement Dictionary.save()
		return S_OK;
	}
	@TJSStatic
	public static int saveStruct( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException, TJSException {
		// Structured output for flie;
		// the content can be interpret as an expression to re-construct the object.
		DictionaryNI ni = getNativeInstance(objthis);
		if( ni == null ) return E_NATIVECLASSCRASH;
		if( !ni.isValid() ) return E_INVALIDOBJECT;
		if( param.length < 1) return E_BADPARAMCOUNT;

		String name = param[0].asString();
		String mode = null;
		if( param.length >= 2 && param[1].isVoid() != true ) mode = param[1].asString();

		TextWriteStream stream = new TextWriteStream(name, mode);
		try {
			ArrayList<Dispatch2> stack = new ArrayList<Dispatch2>();
			stack.add(objthis);
			ni.saveStructuredData( stack, stream, "" );
		} finally {
			stream.destruct();
		}
		if( result != null ) result.set( new Variant(objthis, objthis) );
		return S_OK;
	}
	@TJSStatic
	public static int assign( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException, TJSException {
		DictionaryNI ni = getNativeInstance(objthis);
		if( ni == null ) return E_NATIVECLASSCRASH;
		if( !ni.isValid() ) return E_INVALIDOBJECT;
		if( param.length < 1) return E_BADPARAMCOUNT;

		boolean clear = true;
		if( param.length >= 2 && param[1].isVoid() != true ) clear = param[1].asBoolean();

		VariantClosure clo = param[0].asObjectClosure();
		if( clo.mObjThis != null )
			ni.assign(clo.mObjThis, clear);
		else if( clo.mObject != null )
			ni.assign(clo.mObject, clear);
		else throw new TJSException(Error.NullAccess);
		return S_OK;
	}
	@TJSStatic
	public static int assignStruct( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException, TJSException {
		DictionaryNI ni = getNativeInstance(objthis);
		if( ni == null ) return E_NATIVECLASSCRASH;
		if( !ni.isValid() ) return E_INVALIDOBJECT;
		if( param.length < 1) return E_BADPARAMCOUNT;

		ArrayList<Dispatch2> stack = new ArrayList<Dispatch2>();
		VariantClosure clo = param[0].asObjectClosure();
		if( clo.mObjThis != null )
			ni.assignStructure( clo.mObjThis, stack );
		else if( clo.mObject != null )
			ni.assignStructure(clo.mObject, stack);
		else throw new TJSException(Error.NullAccess);
		return S_OK;
	}
	@TJSStatic
	public static int clear( Variant result, Variant[] param, Dispatch2 objthis ) {
		DictionaryNI ni = getNativeInstance(objthis);
		if( ni == null ) return E_NATIVECLASSCRASH;
		if( !ni.isValid() ) return E_INVALIDOBJECT;
		ni.clear();
		return S_OK;
	}

}
