/*
 * オブジェクトを使わないように個別定義
 */
package jp.kirikiri.tjs2;


public class LongQue {
	private static final int DEFAULT_SIZE = 16;

	private long[] mItems;
	private int mFront;
	private int mTail;

	public LongQue() {
		mItems = new long[DEFAULT_SIZE];
	}
	public boolean isEmpty() {
		return ( mFront == mTail );
	}
	public long front() {
		return mItems[mFront];
	}
	public long pop_front() {
		long ret = mItems[mFront];
		if( mFront == mTail ) {
			return ret; // データが空っぽ
		} else {
			final int mask = mItems.length - 1; // 16の倍数になるので-1でマスクが作れる
			mFront = (mFront + 1) & mask;
		}
		return ret;
	}
	public void push_back( long v ) {
		final int mask = mItems.length - 1; // 16の倍数になるので-1でマスクが作れる
		int tail = (mTail + 1) & mask;
		if( tail == mFront ) { // 溢れる
			final int count = mItems.length << 1;
			long[] newArray = new long[count];
			if( mTail < mFront ) {
				int copySize = mItems.length - mFront;
				System.arraycopy( mItems, mFront, newArray, 0, copySize ); // front ～ 末尾までコピー
				System.arraycopy( mItems, 0, newArray, copySize, mTail ); // 先端 ～ tailまでコピー
				mTail = copySize + mTail;
			} else { // mFront == 0
				System.arraycopy( mItems, 0, newArray, 0, mTail ); // 先端 ～ tailまでコピー
				mTail = mTail;
			}
			mFront = 0;
			mItems = newArray;
			mItems[mTail] = v;
			mTail++;
		} else {
			mItems[mTail] = v;
			mTail = tail;
		}
	}
}

