package jp.kirikiri.tvp2.visual;

import jp.kirikiri.tjs2.Error;
import jp.kirikiri.tjs2.Interface;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.NativeInstanceObject;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.msg.Message;

public class FontNI extends NativeInstanceObject {

	private LayerNI mLayer;

	public int construct( Variant[] param, Dispatch2 tjs_obj ) throws TJSException {

		if( param.length < 1) return Error.E_BADPARAMCOUNT;

		Dispatch2 dsp = param[0].asObject();

		LayerNI ni = (LayerNI)dsp.getNativeInstance( LayerClass.ClassID );
		if( ni == null )
			Message.throwExceptionMessage(Message.SpecifyLayer);
		mLayer = ni;
		return Error.S_OK;
	}
	public void invalidate() throws VariantException, TJSException {
		mLayer = null;
		super.invalidate();
	}

	LayerNI getLayer() { return mLayer; }
}
