package jp.kirikiri.tvp2.visual;

public class GammaAdjustTempData {

	public byte[] B;
	public byte[] G;
	public byte[] R;

	public GammaAdjustTempData() {
		R = new byte[256];
		G = new byte[256];
		B = new byte[256];
	}
	public void Initialize( GammaAdjustData data ) {
		// make table
		double ramp = data.RCeil - data.RFloor;
		double gamp = data.GCeil - data.GFloor;
		double bamp = data.BCeil - data.BFloor;

		double rgamma = 1.0/data.RGamma; /* we assume data.?Gamma is a non-zero value here */
		double ggamma = 1.0/data.GGamma;
		double bgamma = 1.0/data.BGamma;

		double rfloor = data.RFloor;
		double gfloor = data.GFloor;
		double bfloor = data.BFloor;
		for( int i = 0;i < 256; i++ ) {
			double rate = (double)i/255.0;
			int n;
			n = (int)(Math.pow(rate, rgamma)*ramp+0.5+rfloor);
			if(n<0) n=0;
			else if(n>255) n=255;
			R[i]= (byte)( n & 0xff);

			n = (int)(Math.pow(rate, ggamma)*gamp+0.5+gfloor);
			if(n<0) n=0;
			else if(n>255) n=255;
			G[i]= (byte)( n & 0xff);

			n = (int)(Math.pow(rate, bgamma)*bamp+0.5+bfloor);
			if(n<0) n=0;
			else if(n>255) n=255;
			B[i]= (byte)( n & 0xff);
		}
	}
}
