package jp.kirikiri.tvp2.base;

import jp.kirikiri.tjs2.NativeClass;

public class StorageClass extends NativeClass {

	public StorageClass(String name) {
		super("Storage");
	}

	private static final char ArchiveDelimiter = '>';

	public static String extractStorageExt( final String name ) {
		// extract an extension from name.
		// returned string will contain extension delimiter ( '.' ), except for
		// missing extension of the input string.
		// ( returns null string when input string does not have an extension )

		final int slen = name.length();
		int p = slen - 1;
		while( p >= 0 ){
			char c = name.charAt(p);
			if(c == '\\') break;
			if(c == '/') break;
			if(c == ArchiveDelimiter) break;
			if(c == '.') {
				// found extension delimiter
				//int extlen = slen - p;
				return name.substring( p );
			}
			p--;
		}
		// not found
		return new String();
	}
	public static String extractStorageName( final String name ) {
		// extract "name"'s storage name ( excluding path ) and return it.
		final int slen = name.length();
		int p = slen - 1;
		while( p >= 0 ){
			char c = name.charAt(p);
			if(c == '\\') break;
			if(c == '/') break;
			if(c == ArchiveDelimiter) break;
			p--;
		}
		p++;
		if( p <= 0 ) {
			return name;
		} else {
			return name.substring(p);
		}
	}
}
