/**
 * プラットフォーム依存(Android/Java 2D)描画処理を隠蔽する
 */
package jp.kirikiri.tvp2.env;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;

import jp.kirikiri.tvp2.visual.LayerType;
import jp.kirikiri.tvp2.visual.Point;
import jp.kirikiri.tvp2.visual.Rect;

/**
 *
 *
 */
public class DrawTarget {
	private Graphics mGraphcs;
	private WindowForm mWindow;

	public void setGraphics( Graphics g, WindowForm w ) {
		mGraphcs = g;
		mWindow = w;
	}

	public void drawImage(int x, int y, NativeImageBuffer src, Rect refrect, int type, int opacity) {
		try {
			Graphics2D g = (Graphics2D)mGraphcs;
			if ((g != null) && (src.getImage() != null)) {
				if( type == LayerType.ltOpaque ) {
					if( opacity == 255 ) {
						g.setComposite( AlphaComposite.Src );
					} else {
						g.setComposite( AlphaComposite.getInstance( AlphaComposite.SRC, ((float)opacity)/255.0f ) );
					}
				} else {
					if( opacity == 255 ) {
						g.setComposite( AlphaComposite.SrcOver );
					} else {
						g.setComposite( AlphaComposite.getInstance( AlphaComposite.SRC_OVER, ((float)opacity)/255.0f ) );
					}
				}
				g.drawImage( src.getImage(), x, y, x+refrect.width(), y+refrect.height(),
					refrect.left, refrect.top, refrect.right, refrect.bottom, null );
			}
		} catch( NullPointerException ex ){
			// VolatileImageのアクセス中に例外が発生することがあるので、ここでキャッチしておく
		}
	}
	public void show() {
		if( mWindow != null && mWindow.isVisible() ) {
			Toolkit.getDefaultToolkit().sync();
			//mWindow.drawImage();
			mWindow.repaintPanel();
		}
	}
	public void drawLines( Point[] points, int color ) {
		Graphics g = mGraphcs;
		final int count = points.length;
		int[] xPoints = new int[count];
		int[] yPoints = new int[count];
		for( int i = 0; i < count; i++ ) {
			xPoints[i] = points[i].x;
			yPoints[i] = points[i].y;
		}
		g.setColor( new Color(color,false) );
		g.drawPolyline( xPoints, yPoints, count );
	}
}
