package jp.kirikiri.tvp2.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public class Random {
	// 512 is to avoid buffer over-run posibility in multi-threaded access
	static private byte[] RandomSeedPool;
	static private int RandomSeedPoolPos;
	static private byte RandomSeedAtom; // オリジナルでは初期化していない値を使うが、JavaだとゼロクリアされてしまうのでUUIDで初期化する

	static public void initialize() {
		RandomSeedPool = new byte[0x1000 + 512];
		RandomSeedPoolPos = 0;

		UUID uuid = UUID.randomUUID();
		long m = uuid.getMostSignificantBits();
		long l = uuid.getLeastSignificantBits();
		RandomSeedAtom ^= (byte) ((m >> 56) & 0xFF);
		RandomSeedAtom ^= (byte) ((m >> 48) & 0xFF);
		RandomSeedAtom ^= (byte) ((m >> 40) & 0xFF);
		RandomSeedAtom ^= (byte) ((m >> 32) & 0xFF);
		RandomSeedAtom ^= (byte) ((m >> 24) & 0xFF);
		RandomSeedAtom ^= (byte) ((m >> 16) & 0xFF);
		RandomSeedAtom ^= (byte) ((m >> 8) & 0xFF);
		RandomSeedAtom ^= (byte) (m & 0xFF);
		RandomSeedAtom ^= (byte) ((l >> 56) & 0xFF);
		RandomSeedAtom ^= (byte) ((l >> 48) & 0xFF);
		RandomSeedAtom ^= (byte) ((l >> 40) & 0xFF);
		RandomSeedAtom ^= (byte) ((l >> 32) & 0xFF);
		RandomSeedAtom ^= (byte) ((l >> 24) & 0xFF);
		RandomSeedAtom ^= (byte) ((l >> 16) & 0xFF);
		RandomSeedAtom ^= (byte) ((l >> 8) & 0xFF);
		RandomSeedAtom ^= (byte) (l & 0xFF);
	}


	static public void pushEnvironNoise( final byte[] buf ) {
		final int bufsize = buf.length;
		for( int i = 0; i < bufsize; i++ ) {
			RandomSeedPool[RandomSeedPoolPos ++] ^= (RandomSeedAtom ^= buf[i]);
			RandomSeedPoolPos &= 0xfff;
		}
		RandomSeedPoolPos += (buf[0]&1);
		RandomSeedPoolPos &= 0xfff;
	}

	static public void updateEnvironNoiseForTick() {
		long tick = System.currentTimeMillis();
		pushEnvironNoise( tick );
	}
	static public void pushEnvironNoise( long val ) {
		byte[] buf = new byte[8];
		buf[0] = (byte) ((val >> 56) & 0xFF);
		buf[1] = (byte) ((val >> 48) & 0xFF);
		buf[2] = (byte) ((val >> 40) & 0xFF);
		buf[3] = (byte) ((val >> 32) & 0xFF);
		buf[4] = (byte) ((val >> 24) & 0xFF);
		buf[5] = (byte) ((val >> 16) & 0xFF);
		buf[6] = (byte) ((val >> 8) & 0xFF);
		buf[7] = (byte) (val & 0xFF);
		Random.pushEnvironNoise( buf );
		buf = null;
	}
	static public void pushEnvironNoise( int val ) {
		byte[] buf = new byte[4];
		buf[0] = (byte) ((val >> 24) & 0xFF);
		buf[1] = (byte) ((val >> 16) & 0xFF);
		buf[2] = (byte) ((val >> 8) & 0xFF);
		buf[3] = (byte) (val & 0xFF);
		Random.pushEnvironNoise( buf );
		buf = null;
	}
	static public void getRandomBits128( byte[] dest ) {
		// retrieve random bits
		pushEnvironNoise( RandomSeedPoolPos );
		UUID uuid = UUID.randomUUID();
		long m = uuid.getMostSignificantBits();
		long l = uuid.getLeastSignificantBits();
		if( dest.length >= 16 ) {
			dest[0] = (byte) ((m >> 56) & 0xFF);
			dest[1] = (byte) ((m >> 48) & 0xFF);
			dest[2] = (byte) ((m >> 40) & 0xFF);
			dest[3] = (byte) ((m >> 32) & 0xFF);
			dest[4] = (byte) ((m >> 24) & 0xFF);
			dest[5] = (byte) ((m >> 16) & 0xFF);
			dest[6] = (byte) ((m >> 8) & 0xFF);
			dest[7] = (byte) (m & 0xFF);
			dest[8] = (byte) ((l >> 56) & 0xFF);
			dest[9] = (byte) ((l >> 48) & 0xFF);
			dest[10] = (byte) ((l >> 40) & 0xFF);
			dest[11] = (byte) ((l >> 32) & 0xFF);
			dest[12] = (byte) ((l >> 24) & 0xFF);
			dest[13] = (byte) ((l >> 16) & 0xFF);
			dest[14] = (byte) ((l >> 8) & 0xFF);
			dest[15] = (byte) (l & 0xFF);
			pushEnvironNoise( dest );
		}

		// make 128bit hash of RandomSeedPool, using MD5 message digest
	    MessageDigest md;
		try {
			md = MessageDigest.getInstance("MD5");
		    md.update(RandomSeedPool,0,0x1000);
		    byte[] digest = md.digest();
		    for( int i = 0; i < digest.length && i < dest.length; i++ ) {
		    	dest[i] ^= digest[i]; // UUID も混ぜる
		    }
			// push hash itself
		    pushEnvironNoise( digest );
		} catch (NoSuchAlgorithmException e) {
			// 見付からない時は、UUID で得たものをそのまま使う
		}
	}
}

