package jp.kirikiri.tjs2;

import java.util.Random;

public class MathClass extends NativeClass {

	static private final int
		E_BADPARAMCOUNT	= -1004,
		S_OK			= 0;

	static private int mClassID;
	static private Random mRandomGenerator;

	public MathClass() throws VariantException, TJSException {
		super("Math");

		if( mRandomGenerator == null ) {
			mRandomGenerator = new Random( System.currentTimeMillis() );
		}

		final String __classname = "Math";
		final int NCM_CLASSID = TJS.registerNativeClass(__classname);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		Class<? extends MathClass> c = getClass();
		registerMethods( c, __classname );
	}
	public static int constructor( Variant result, Variant[] param, Dispatch2 objthis ) {
		return S_OK;
	}
	@TJSStatic
	public static int abs( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( param.length < 1 ) return E_BADPARAMCOUNT;
		if( result != null ) result.set( Math.abs( param[0].asDouble() ) );
		return S_OK;
	}
	@TJSStatic
	public static int acos( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( param.length < 1 ) return E_BADPARAMCOUNT;
		if( result != null ) result.set( Math.acos( param[0].asDouble() ) );
		return S_OK;
	}
	@TJSStatic
	public static int asin( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( param.length < 1 ) return E_BADPARAMCOUNT;
		if( result != null ) result.set( Math.asin( param[0].asDouble() ) );
		return S_OK;
	}
	@TJSStatic
	public static int atan( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( param.length < 1 ) return E_BADPARAMCOUNT;
		if( result != null ) result.set( Math.atan( param[0].asDouble() ) );
		return S_OK;
	}
	@TJSStatic
	public static int atan2( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( param.length < 2 ) return E_BADPARAMCOUNT;
		if( result != null ) result.set( Math.atan2( param[0].asDouble(), param[1].asDouble() ) );
		return S_OK;
	}
	@TJSStatic
	public static int ceil( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( param.length < 1 ) return E_BADPARAMCOUNT;
		if( result != null ) result.set( Math.ceil( param[0].asDouble() ) );
		return S_OK;
	}
	@TJSStatic
	public static int exp( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( param.length < 1 ) return E_BADPARAMCOUNT;
		if( result != null ) result.set( Math.exp( param[0].asDouble() ) );
		return S_OK;
	}
	@TJSStatic
	public static int floor( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( param.length < 1 ) return E_BADPARAMCOUNT;
		if( result != null ) result.set( Math.floor( param[0].asDouble() ) );
		return S_OK;
	}
	@TJSStatic
	public static int log( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( param.length < 1 ) return E_BADPARAMCOUNT;
		if( result != null ) result.set( Math.log( param[0].asDouble() ) );
		return S_OK;
	}
	@TJSStatic
	public static int pow( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( param.length < 2 ) return E_BADPARAMCOUNT;
		if( result != null ) result.set( Math.pow( param[0].asDouble(), param[1].asDouble() ) );
		return S_OK;
	}
	@TJSStatic
	public static int max( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( result != null ) {
			double r = Double.NEGATIVE_INFINITY;
			final int count = param.length;
			for( int i = 0; i < count; i++ ) {
				double v = param[i].asDouble();
				if( Double.isNaN(v) ) {
					result.set( Double.NaN );
					return S_OK;
				} else if( Double.compare( v, r ) > 0 ) {
					r = v;
				}
			}
			result.set( r );
		}
		return S_OK;
	}
	@TJSStatic
	public static int min( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( result != null ) {
			double r = Double.POSITIVE_INFINITY;
			final int count = param.length;
			for( int i = 0; i < count; i++ ) {
				double v = param[i].asDouble();
				if( Double.isNaN(v) ) {
					result.set( Double.NaN );
					return S_OK;
				} else if( Double.compare( v, r ) < 0 ) {
					r = v;
				}
			}
			result.set( r );
		}
		return S_OK;
	}
	@TJSStatic
	public static int random( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( result != null ) result.set( mRandomGenerator.nextDouble() );
		return S_OK;
	}
	@TJSStatic
	public static int round( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( param.length < 1 ) return E_BADPARAMCOUNT;
		if( result != null ) result.set( Math.round( param[0].asDouble() ) );
		return S_OK;
	}
	@TJSStatic
	public static int sin( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( param.length < 1 ) return E_BADPARAMCOUNT;
		if( result != null ) result.set( Math.sin( param[0].asDouble() ) );
		return S_OK;
	}
	@TJSStatic
	public static int cos( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( param.length < 1 ) return E_BADPARAMCOUNT;
		if( result != null ) result.set( Math.cos( param[0].asDouble() ) );
		return S_OK;
	}
	@TJSStatic
	public static int sqrt( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( param.length < 1 ) return E_BADPARAMCOUNT;
		if( result != null ) result.set( Math.sqrt( param[0].asDouble() ) );
		return S_OK;
	}
	@TJSStatic
	public static int tan( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( param.length < 1 ) return E_BADPARAMCOUNT;
		if( result != null ) result.set( Math.tan( param[0].asDouble() ) );
		return S_OK;
	}
	@TJSStatic
	public static int prop_get_E( Variant result, Dispatch2 objthis ) {
		result.set( 2.7182818284590452354 );
		return S_OK;
	}
	@TJSStatic
	public static int prop_get_LOG2E( Variant result, Dispatch2 objthis ) {
		result.set( 1.4426950408889634074 );
		return S_OK;
	}
	@TJSStatic
	public static int prop_get_LOG10E( Variant result, Dispatch2 objthis ) {
		result.set( 0.4342944819032518276 );
		return S_OK;
	}
	@TJSStatic
	public static int prop_get_LN10( Variant result, Dispatch2 objthis ) {
		result.set( 2.30258509299404568402 );
		return S_OK;
	}
	@TJSStatic
	public static int prop_get_LN2( Variant result, Dispatch2 objthis ) {
		result.set( 0.69314718055994530942 );
		return S_OK;
	}
	@TJSStatic
	public static int prop_get_PI( Variant result, Dispatch2 objthis ) {
		result.set( 3.14159265358979323846 );
		return S_OK;
	}
	@TJSStatic
	public static int prop_get_SQRT1_2( Variant result, Dispatch2 objthis ) {
		result.set( 0.70710678118654752440 );
		return S_OK;
	}
	@TJSStatic
	public static int prop_get_SQRT2( Variant result, Dispatch2 objthis ) {
		result.set( 1.41421356237309504880 );
		return S_OK;
	}
}
