package jp.kirikiri.tvp2.utils;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.Logger;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeClassProperty;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;

public class KAGParserClass extends NativeClass {

	static private int mClassID = -1;
	static private final int
		E_MEMBERNOTFOUND = -1001,
		E_NOTIMPL		= -1002,
		E_BADPARAMCOUNT	= -1004,
		E_INVALIDOBJECT	= -1006,
		E_ACCESSDENYED	= -1007,
		E_NATIVECLASSCRASH = -1008,
		S_OK			= 0,
		S_TRUE			= 1;
	static private final int
		NIS_GETINSTANCE		= 0x00000002; // get native pointer
	static private final int // enum tTJSNativeInstanceType
		nitMethod	= 1,
		nitProperty = 2;

	static final private int STATICMEMBER	= 0x00010000;

	static private final String CLASS_NAME = "KAGParser";

	protected NativeInstance createNativeInstance() {
		return new KAGParserNI();
	}

	public KAGParserClass() throws VariantException, TJSException {
		super( CLASS_NAME );
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		// constructor
		registerNCM( CLASS_NAME, new NativeClassConstructor() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		registerNCM( "finalize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "loadScenario", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "goToLabel", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "callLabel", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "getNextTag", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "assign", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "clear", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "store", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "restore", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "clearCallStack", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "popMacroArgs", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "interrupt", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "resetInterrupt", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );


		registerNCM( "curLine", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "curPos", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "curLineStr", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "processSpecialTags", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "ignoreCR", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "debugLevel", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "macros", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "macroParams", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "mp", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "callStackDepth", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "curStorage", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "curLabel", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );
	}

}
