package jp.kirikiri.tvp2.base;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.TVP;

// TODO このクラスは環境依存のところに移動した方がいいな
public class TVPSystem {

	public static String getPlatformName() {
		return System.getProperty("os.name");
	}
	public static String getOSName() {
		String os = System.getProperty("os.name");
		String arch = System.getProperty("os.arch");
		String version = System.getProperty("os.version");
		StringBuilder builder = new StringBuilder(256);
		builder.append(os);
		builder.append(" ");
		builder.append(version);
		builder.append(" ");
		builder.append(arch);
		return builder.toString();
	}
	public static String getJREName() {
		String vendor = System.getProperty("java.vendor");
		String version = System.getProperty("java.version");
		StringBuilder builder = new StringBuilder(256);
		builder.append(version);
		builder.append(" ");
		builder.append(vendor);
		return builder.toString();
	}
	public static String getJRESpecName() {
		String name = System.getProperty("java.specification.name");
		String vendor = System.getProperty("java.specification.vendor");
		String version = System.getProperty("java.specification.version");
		StringBuilder builder = new StringBuilder(256);
		builder.append(name);
		builder.append(" ");
		builder.append(version);
		builder.append(" ");
		builder.append(vendor);
		return builder.toString();
	}
	public static String getJVMSpecName() {
		String name = System.getProperty("java.vm.specification.name");
		String vendor = System.getProperty("java.vm.specification.vendor");
		String version = System.getProperty("java.vm.specification.version");
		StringBuilder builder = new StringBuilder(256);
		builder.append(name);
		builder.append(" ");
		builder.append(version);
		builder.append(" ");
		builder.append(vendor);
		return builder.toString();
	}
	public static String getJVMName() {
		String name = System.getProperty("java.vm.name");
		String vendor = System.getProperty("java.vm.vendor");
		String version = System.getProperty("java.vm.version");
		StringBuilder builder = new StringBuilder(256);
		builder.append(name);
		builder.append(" ");
		builder.append(version);
		builder.append(" ");
		builder.append(vendor);
		return builder.toString();
	}
	public static int getProcessorNum() {
		Runtime runtime = Runtime.getRuntime();
		return runtime.availableProcessors();
	}
}
