/**
 ******************************************************************************
 * Copyright (c), Takenori Imoto
 *  software http://www.kaede-software.com/
 * All rights reserved.
 ******************************************************************************
 * \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏
 * ꍇɌAĔЕzюgp܂B
 *
 * E\[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐ
 *   ܂߂邱ƁB
 * EoCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL
 *   쌠\A{ꗗAщLƐӏ܂߂邱ƁB
 * Eʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔
 *   iɁAgD̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB
 *
 * {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v
 * ĂAَ킸AƓIȎgp\Aѓ̖ړIɑ΂K
 * ɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂
 * B쌠҂Rgr[^[AR̂킸AQ̌
 * 킸AӔC̍_ł邩iӔCł邩iߎ̑́js@
 * sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂ
 * ĂA{\tgEFA̎gpɂĔi֕i܂͑pT[rX̒BA
 * gp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳
 * jڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQ
 * āAؐӔC𕉂Ȃ̂Ƃ܂B
 ******************************************************************************
 * {\tgEFÁAgg2 ( http://kikyou.info/tvp/ ) ̃\[XR[hJava
 * ɏ̂ꕔgpĂ܂B
 * gg2 Copyright (C) W.Dee <dee@kikyou.info> and contributors
 ******************************************************************************
 */
package jp.kirikiri.tvp2.visual;

import java.util.ArrayList;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.TJSScriptError;
import jp.kirikiri.tjs2.TJSScriptException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.CompactEventCallbackInterface;

public class TempBitmapHolder implements CompactEventCallbackInterface {
	static final private int INIT_SIZE = 32;
	static final private int INIT_BPP = 32;
	static final private int INIT_COLOR = 0x00FFFFFF; //TVP_RGBA2COLOR(255, 255, 255, 0));

	static private TempBitmapHolder TempBitmapHolder;
	static public void initialize() {
		TempBitmapHolder = null;
	}
	public static void finalizeApplication() {
		TempBitmapHolder = null;
	}

	private BaseBitmap mBitmap;
	private ArrayList<BaseBitmap> mTemporaries;
	private int mTempLevel;
	private boolean mTempCompactInit;

	private TempBitmapHolder() throws TJSException {
		mBitmap = new BaseBitmap(INIT_SIZE,INIT_SIZE,INIT_BPP);
		mTemporaries = new ArrayList<BaseBitmap>();
		//mTempLevel = 0;
		//mTempCompactInit = false;
		// the default image must be a transparent, white colored rectangle
		mBitmap.fill( new Rect(0, 0, INIT_SIZE, INIT_SIZE), INIT_COLOR );
	}

	protected void finalize() {
		final int count = mTemporaries.size();
		for( int i = 0; i < count; i++ ) {
			mTemporaries.set(i,null);
		}
		if(mTempCompactInit && TVP.EventManager != null ) TVP.EventManager.removeCompactEventHook(this);
	}

	private BaseBitmap internalGetTemp( int w, int h, boolean fit ) throws TJSException {
		// compact initialization
		if(!mTempCompactInit) {
			TVP.EventManager.addCompactEventHook(this);
			mTempCompactInit = true;
		}

		// align width to even
		if(!fit) w += (w & 1);

		// get temporary bitmap (nested)
		mTempLevel++;
		if(mTempLevel > mTemporaries.size()) {
			// increase buffer size
			BaseBitmap bmp = new BaseBitmap(w, h, INIT_BPP);
			mTemporaries.add(bmp);
			return bmp;
		} else {
			BaseBitmap bmp = mTemporaries.get(mTempLevel -1);
			if(!fit) {
				int bw = bmp.getWidth();
				int bh = bmp.getHeight();
				if(bw < w || bh < h) {
					// increase image size
					bmp.setSize(bw > w ? bw:w, bh > h ? bh:h, false);
				}
			} else {
				// the size must be fitted
				int bw = bmp.getWidth();
				int bh = bmp.getHeight();
				if(bw != w || bh != h)
					bmp.setSize(w, h, false);
			}
			return bmp;
		}
	}

	private void internalFreeTemp() {
		if(mTempLevel == 0) return ; // this must be a logical failure
		mTempLevel--;
		//compactTempBitmap(); // always compact
	}

	private void compactTempBitmap() {
		// compact tmporary bitmap cache
		final int count = mTemporaries.size();
		for( int i = count-1; i >= mTempLevel; i-- ) {
			BaseBitmap bmp = mTemporaries.get(i);
			bmp.purgeImage();
			mTemporaries.remove(i);
		}
	}
	@Override
	public void onCompact(int level) throws TJSScriptException, TJSScriptError, TJSException {
		// OnCompact method from tTVPCompactEventCallbackIntf
		// called when the application is idle, deactivated, minimized, or etc...
		if(level >= CompactEventCallbackInterface.COMPACT_LEVEL_DEACTIVATE) compactTempBitmap();
	}

	static BaseBitmap get() throws TJSException {
		if( TempBitmapHolder == null ) TempBitmapHolder = new TempBitmapHolder();
		return TempBitmapHolder.mBitmap;
	}

	static BaseBitmap getTemp( int w, int h ) throws TJSException {
		return getTemp( w, h, false );
	}
	static BaseBitmap getTemp( int w, int h, boolean fit ) throws TJSException {
		if( TempBitmapHolder == null ) TempBitmapHolder = new TempBitmapHolder();
		return TempBitmapHolder.internalGetTemp(w, h, fit);
	}

	static void freeTemp() {
		if( TempBitmapHolder != null ) {
			TempBitmapHolder.internalFreeTemp();
		}
	}
}
