package jp.kirikiri.tvp2env;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;

import javax.swing.JPanel;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.visual.BaseBitmap;
import jp.kirikiri.tvp2.visual.GraphicsLoader;


public class ImagePanel extends JPanel {

	/**
	 *
	 */
	private static final long serialVersionUID = 7393364494465761702L;

	private VRAMImageBuffer mImageBuffer;	// VRAMバッファ
	private PanelDrawListener mDraw;

	private NativeImageBuffer mImage;
	private WindowForm mWindow;

	//コンストラクタ
	public ImagePanel() {
		super();
		mImageBuffer = new VRAMImageBuffer(this);
		mImage = new NativeImageBuffer(32,32);
	}
	public void setOwner( WindowForm window ) {
		mWindow = window;
	}
	@Override
	public void setSize(int w, int h ) {
		super.setSize(w,h);
		if( w != 0 && h != 0 ) {
			try {
				mImage.recreate(w, h, true);
				if( mDraw != null ) {
					Image img = mImage.getImage();
					if( img != null ) {
						mDraw.onDraw( img.getGraphics() );
					}
				}
			} catch (TJSException e) {
			}
		}

/*
		mImageBuffer.initializeVolatileImage();
		try {
			do {
				// ダブルバッファ用イメージのチェック
				mImageBuffer.validateVolatileImage();
				if( mDraw != null ) {
					Image img = mImageBuffer.getImage();
					if( img != null ) {
						mDraw.onDraw( img.getGraphics() );
					}
				}
				// バッファ内容が失われたら再描画させる
			} while( mImageBuffer.isContentsLost() );
		} catch( NullPointerException ex ){
			// VolatileImageのアクセス中に例外が発生することがあるので、ここでキャッチしておく
		}
*/
	}
	/*
	public Graphics getTargetGraphics() {
		return mImage.getImage().getGraphics();
	}
	*/
	/*
	private void loadImage() {
		BaseBitmap bmp = new BaseBitmap(32,32,32);
		try {
			GraphicsLoader.loadGraphic( bmp, "kaname_kira.png", 0, 0, 0, GraphicsLoader.glmNormal, null );
		} catch (TJSException e) {
		}
		mTestImage = (BufferedImage) bmp.getBitmap().getImage();
	}
	*/

	// 画面の描画処理
	protected void paintComponent( Graphics graphic ) {
		// ダブルバッファ用イメージの初期化
		mImageBuffer.initializeVolatileImage();
		try {
			do {
				// ダブルバッファ用イメージのチェック
				mImageBuffer.validateVolatileImage();

				// バッファのグラフィックスオブジェクトを取得
				Graphics buffer = mImageBuffer.getGraphics();

				// 親クラスの描画処理を呼びだす
				// super.paintComponent(buffer); 余計な塗りつぶしをなくす

				// 具体的な描画処理を入れる
				buffer.drawImage(mImage.getImage(), 0, 0, null );

				// グラフィックスオブジェクトを破棄する
				buffer.dispose();

				// バッファのイメージを実際に描画する
				if( mWindow != null ) {
					Graphics2D g = (Graphics2D)graphic;
					int ow = mWindow.getInnerWidthSave();
					int oh = mWindow.getInnerHeightSave();
					int dw = mWindow.getInnerWidth();
					int dh = mWindow.getInnerHeight();
					if( ow == dw || oh == dh ) {
						graphic.drawImage(mImageBuffer.getImage(),0,0,this);
					} else {
						int rw = (1000 * dw) / ow;
						int rh = (1000 * dh) / oh;
						int x, y, w, h;
						if( rw < rh ) {
							w = dw;
							h = (oh * dw) / ow;
							x = 0;
							y = (dh - h)/2;
						} else {
							w = (ow * dh) / oh;
							h = dh;
							x = (dw - w)/2;
							y = 0;
						}
						g.setRenderingHint(RenderingHints.KEY_INTERPOLATION , RenderingHints.VALUE_INTERPOLATION_BILINEAR );
						//g.setRenderingHint(RenderingHints.KEY_INTERPOLATION , RenderingHints.VALUE_INTERPOLATION_BICUBIC );
						//g.setRenderingHint(RenderingHints.KEY_INTERPOLATION , RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR );
						g.drawImage(mImageBuffer.getImage(),x,y,x+w,y+h,0,0,ow,oh,this);
					}
				}
				// バッファ内容が失われたら再描画させる
			} while( mImageBuffer.isContentsLost() );
		} catch( NullPointerException ex ){
			// VolatileImageのアクセス中に例外が発生することがあるので、ここでキャッチしておく
		}
	}
	public void drawImage( Graphics graphic, int ox, int oy ) {
		try {
			if( mWindow != null ) {
				Graphics2D g = (Graphics2D)graphic;
				int ow = mWindow.getInnerWidthSave();
				int oh = mWindow.getInnerHeightSave();
				int dw = mWindow.getInnerWidth();
				int dh = mWindow.getInnerHeight();
				if( ow == dw || oh == dh ) {
					graphic.drawImage(mImage.getImage(),ox,oy,this);
				} else {
					int rw = (1000 * dw) / ow;
					int rh = (1000 * dh) / oh;
					int x, y, w, h;
					if( rw < rh ) {
						w = dw;
						h = (oh * dw) / ow;
						x =  ox;
						y = (dh - h)/2 + oy;
					} else {
						w = (ow * dh) / oh;
						h = dh;
						x = (dw - w)/2 + ox;
						y = oy;
					}
					g.setRenderingHint(RenderingHints.KEY_INTERPOLATION , RenderingHints.VALUE_INTERPOLATION_BILINEAR );
					//g.setRenderingHint(RenderingHints.KEY_INTERPOLATION , RenderingHints.VALUE_INTERPOLATION_BICUBIC );
					//g.setRenderingHint(RenderingHints.KEY_INTERPOLATION , RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR );
					g.drawImage(mImage.getImage(),x,y,x+w,y+h,0,0,ow,oh,this);
				}
			}
		} catch( NullPointerException ex ){
		}
	}
	public void setDrawListener( PanelDrawListener draw ) {
		mDraw = draw;
		//if( mDraw != null ) mDraw.onDraw( mImage.getImage().getGraphics() );
	}
}
