package jp.kirikiri.tvp2.visual;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.TJSException;

public interface WindowInterface {
	/**
	 *  @throws TJSException
	 * @brief	元画像のサイズが変更された
	 *  @note	描画デバイスが、元画像のサイズが変更されたことを通知するために呼ぶ。
	 * 			ウィンドウは iTVPDrawDevice::GetSrcSize() を呼び出して元画像の
	 * 			サイズを取得した後、ズームなどの計算を行ってから
	 * 			iTVPDrawDevice::SetTargetWindow() を呼び出す。
	 */
	public void notifySrcResize() throws TJSException;

	/**
	 *  @brief		マウスカーソルの形状をデフォルトに戻す
	 *  @note		マウスカーソルの形状をデフォルトの物に戻したい場合に呼ぶ
	 */
	public void setDefaultMouseCursor(); // set window mouse cursor to default

	/**
	 *  @brief		マウスカーソルの形状を設定する
	 *  @param		cursor		マウスカーソル形状番号
	 */
	public void setMouseCursor( int cursor ); // set window mouse cursor

	/**
	 *  @brief		マウスカーソルの位置を取得する
	 *  @param		x			描画矩形内の座標におけるマウスカーソルのx位置
	 *  @param		y			描画矩形内の座標におけるマウスカーソルのy位置
	 */
	public void getCursorPos( Point pt );
		// get mouse cursor position in primary layer's coordinates

	/**
	 *  @brief		マウスカーソルの位置を設定する
	 *  @param		x			描画矩形内の座標におけるマウスカーソルのx位置
	 *  @param		y			描画矩形内の座標におけるマウスカーソルのy位置
	 */
	public void setCursorPos( int x, int y );

	/**
	 *  @brief		ウィンドウのマウスキャプチャを解放する
	 *  @note		ウィンドウのマウスキャプチャを解放すべき場合に呼ぶ。
	 *  @note		このメソッドでは基本的には ::ReleaseCapture() などで
	 * 				マウスのキャプチャを開放すること。
	 */
	public void windowReleaseCapture();

	/**
	 *  @brief		ツールチップヒントを設定する
	 *  @param		text		ヒントテキスト(空文字列の場合はヒントの表示をキャンセルする)
	 */
	public void setHintText( final String text );

	/**
	 *  @brief		注視ポイントの設定
	 *  @param		layer		フォント情報の含まれるレイヤ
	 *  @param		pt			描画矩形内の座標における注視ポイントの位置
	 */
	public void setAttentionPoint( LayerNI layer, Point pt );

	/**
	 *  @brief		注視ポイントの解除
	 */
	public void disableAttentionPoint();

	/**
	 *  @brief		IMEモードの設定
	 *  @param		mode		IMEモード
	 */
	public void setImeMode( int mode );

	/**
	 *  @brief		IMEモードのリセット
	 */
	public void resetImeMode();

	/**
	 *  @brief		iTVPWindow::Update() の呼び出しを要求する
	 *  @note		ウィンドウに対して iTVPWindow::Update() を次の適当なタイミングで
	 * 				呼び出すことを要求する。
	 * 				iTVPWindow::Update() が呼び出されるまでは何回 RequestUpdate() を
	 * 				呼んでも効果は同じである。また、一度 iTVPWindow::Update() が
	 * 				呼び出されると、再び RequestUpdate() を呼ばない限りは
	 * 				iTVPWindow::Update() は呼ばれない。
	 */
	public void requestUpdate();


	/**
	 *  @brief		WindowのiTJSDispatch2インターフェースを取得する
	 */
	public Dispatch2 getWindowDispatch();
}
