package jp.kirikiri.tvp2.visual;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.Logger;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeClassProperty;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;

public class WindowClass extends NativeClass {

	static private int mClassID = -1;
	static private final int
		E_MEMBERNOTFOUND = -1001,
		E_NOTIMPL		= -1002,
		E_BADPARAMCOUNT	= -1004,
		E_INVALIDOBJECT	= -1006,
		E_ACCESSDENYED	= -1007,
		E_NATIVECLASSCRASH = -1008,
		S_OK			= 0,
		S_TRUE			= 1;
	static private final int
		NIS_GETINSTANCE		= 0x00000002; // get native pointer
	static private final int // enum tTJSNativeInstanceType
		nitMethod	= 1,
		nitProperty = 2;

	static final private int STATICMEMBER	= 0x00010000;

	static private final String CLASS_NAME = "Window";

	protected NativeInstance createNativeInstance() {
		return null;
	}

	public WindowClass() throws VariantException, TJSException {
		super( CLASS_NAME );
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		// constructor
		registerNCM( CLASS_NAME, new NativeClassConstructor() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		registerNCM( "finalize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "close", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "beginMove", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "bringToFront", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "update", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "showModal", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "setMaskRegion", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "removeMaskRegion", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "add", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "remove", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "setSize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "setMinSize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "setMaxSize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "setPos", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "setLayerPos", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "setInnerSize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "setZoom", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "hideMouseCursor", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "postInputEvent", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "findFullScreenCandidates", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "registerMessageReceiver", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );


		// event
		registerNCM( "onResize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "onMouseEnter", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "onMouseLeave", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "onClick", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "onDoubleClick", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "onMouseDown", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "onMouseUp", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "onMouseMove", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "onMouseWheel", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "onKeyDown", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "onKeyUp", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "onKeyPress", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "onFileDrop", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "onCloseQuery", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "onPopupHide", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "onActivate", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "onDeactivate", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );



		registerNCM( "visible", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "caption", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "width", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "height", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "minWidth", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "minHeight", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "maxWidth", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "maxHeight", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "left", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "top", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "focusable", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "layerLeft", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "layerTop", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "innerSunken", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "innerWidth", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "innerHeight", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "zoomNumer", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "zoomDenom", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "borderStyle", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "stayOnTop", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "showScrollBars", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "useMouseKey", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "trapKey", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "imeMode", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "mouseCursorState", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "menu", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "fullScreen", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "mainWindow", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "focusedLayer", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "primaryLayer", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "HWND", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "drawDevice", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );
	}

}
