/*
 * オブジェクトを使わないように個別定義
 */
package jp.kirikiri.tjs2;


public class IntVector {
	private static final int DEFAULT_SIZE = 16;

	private int[] mItems;
	private int mIndex;

	public IntVector() {
		this(DEFAULT_SIZE);
	}
	public IntVector(int initialCapacity) {
		mItems = new int[initialCapacity];
	}
	public IntVector( int[] datasrc, int index ) {
		mItems = new int[index];
		mIndex = index;
		for( int i = 0; i < index; i++ ) {
			mItems[i] = datasrc[i];
		}
	}

	private final void resize() {
		final int count = mItems.length * 2;
		int[] newArray = new int[count];
		System.arraycopy( mItems, 0, newArray, 0, mItems.length );
		mItems = null;
		mItems = newArray;
	}

	public final void clear() {
		mIndex = 0;
	}
	public final void push_back( int val ) {
		if( mIndex < mItems.length ) {
			mItems[mIndex] = val;
			mIndex++;
		} else {
			resize();
			if( mIndex < mItems.length ) {
				mItems[mIndex] = val;
				mIndex++;
			} else {
				throw new OutOfMemoryError( Error.InternalError );
			}
		}
	}
	public final void add( int val ) {
		if( mIndex < mItems.length ) {
			mItems[mIndex] = val;
			mIndex++;
		} else {
			resize();
			if( mIndex < mItems.length ) {
				mItems[mIndex] = val;
				mIndex++;
			} else {
				throw new OutOfMemoryError( Error.InternalError );
			}
		}
	}
	public final int size() { return mIndex; }

	public final int lastElement() throws IndexOutOfBoundsException {
		if( mIndex == 0 ) throw new IndexOutOfBoundsException();
		return mItems[mIndex-1];
	}
	public final int back() throws IndexOutOfBoundsException {
		if( mIndex == 0 ) throw new IndexOutOfBoundsException();
		return mItems[mIndex-1];
	}
	public final int top() throws IndexOutOfBoundsException {
		if( mIndex == 0 ) throw new IndexOutOfBoundsException();
		return mItems[0];
	}
	public final void pop_back() {
		if( mIndex > 0 ) {
			mIndex--;
		}
	}
	public final void set( int index, int element ) {
		if( index >= 0 && index < mIndex ) {
			mItems[index] = element;
		}
	}
	public final int get( int index ) throws IndexOutOfBoundsException {
		if( index < 0 && index >= mIndex ) throw new IndexOutOfBoundsException();
		return mItems[index];
	}
	public final void remove( int index ) throws IndexOutOfBoundsException {
		if( index < 0 && index >= mIndex ) throw new IndexOutOfBoundsException();

		final int count = mIndex - 1;
		for( int i = index; i < count; i++ ) {
			mItems[i] = mItems[i+1];
		}
		mIndex--;
	}

	public IntVector clone() {
		return new IntVector( mItems, mIndex );
	}
}

