package jp.kirikiri.tvp2env;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.visual.BaseTransHandler;
import jp.kirikiri.tvp2.visual.SimpleImageProvider;
import jp.kirikiri.tvp2.visual.SimpleOptionProvider;
import jp.kirikiri.tvp2.visual.TransHandlerProvider;

public class RotateZoomTransHandlerProvider implements TransHandlerProvider {

	private static final String TIME = "time";
	private static final String FACTOR = "factor";
	private static final String ACCEL = "accel";
	private static final String TWIST = "twist";
	private static final String TWISTACCEL = "twistaccel";
	private static final String CENTERX = "centerx";
	private static final String CENTERY = "centery";

	private Variant mVariantRet;
	protected long[] mLogValueRet;

	public RotateZoomTransHandlerProvider() {
		mVariantRet = new Variant();
		mLogValueRet = new long[1];
	}

	@Override
	public String getName() { return "rotatezoom"; }

	@Override
	public BaseTransHandler startTransition(SimpleOptionProvider options,
			SimpleImageProvider imagepro, int layertype, int src1w, int src1h,
			int src2w, int src2h, int[] type) throws TJSException {

		if( type != null && type.length >= 1 ) type[0] = ttExchange; // transition type : exchange
		if( type != null && type.length >= 2 ) type[1] = tutDivisible; // update type : divisible
			// update type : divisible fade
		if( options == null ) return null;

		if(src1w != src2w || src1h != src2h)
			Message.throwExceptionMessage( Message.TransitionLayerSizeMismatch,
				 String.valueOf(src2w) + "x" + src2h,
				 String.valueOf(src1w) + "x" + src1h );

		// オプションを得る
		// retrieve "time" option
		int er = options.getAsNumber( TIME, mLogValueRet );
		if( er < 0 ) Message.throwExceptionMessage( Message.SpecifyOption, TIME );
		long time = mLogValueRet[0];
		if( time < 2) time = 2; // あまり小さな数値を指定すると問題が起きるので

		er = options.getValue( FACTOR, mVariantRet );
		double factor = 1.0;
		if( er >= 0 && mVariantRet.isVoid() != true ) {
			factor = mVariantRet.asDouble();
		}
		mVariantRet.clear();

		er = options.getValue( ACCEL, mVariantRet );
		double accel = 0.0;
		if( er >= 0 && mVariantRet.isVoid() != true ) {
			accel = mVariantRet.asDouble();
		}
		mVariantRet.clear();

		er = options.getValue( TWIST, mVariantRet );
		double twist = 2.0;
		if( er >= 0 && mVariantRet.isVoid() != true ) {
			twist = mVariantRet.asDouble();
		}
		mVariantRet.clear();

		er = options.getValue( TWISTACCEL, mVariantRet );
		double twistaccel = -2.0;
		if( er >= 0 && mVariantRet.isVoid() != true ) {
			twistaccel = mVariantRet.asDouble();
		}
		mVariantRet.clear();

		er = options.getAsNumber( CENTERX, mLogValueRet );
		int centerx = src1w / 2;
		if( er >= 0 ) centerx = (int) mLogValueRet[0];

		er = options.getAsNumber( CENTERY, mLogValueRet );
		int centery = src1h / 2;
		if( er >= 0 ) centerx = (int) mLogValueRet[0];

		// オブジェクトを作成
		return new RotateZoomTransHandler(time, src1w, src1h, factor, 1, accel, twist, twistaccel, centerx, centery, true );
	}

}
