package jp.kirikiri.tvp2.visual;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;

public class SimpleOptionProviderObject implements SimpleOptionProvider {

	static private final int S_OK = 0;
	//static private final int S_FALSE = 2;
	static private final int E_MEMBERNOTFOUND = -1001;
	static private final int E_FAIL = -1;

	private VariantClosure mObject;
	//private String mString;
	private Variant mRetVariant;

	public SimpleOptionProviderObject( VariantClosure object ) {
		mObject = object;
		mRetVariant = new Variant();
	}
	@Override
	public int getAsNumber(String name, long[] value) {
		try {
			mRetVariant.clear();
			int er = mObject.propGet( 0, name, mRetVariant, null );
			if( er < 0 ) return er;

			if( mRetVariant.isVoid() ) return E_MEMBERNOTFOUND;

			if( value != null ) value[0] = mRetVariant.asInteger();
			mRetVariant.clear();

			return S_OK;
		} catch( TJSException e ) {
			return E_FAIL;
		}
	}

	@Override
	public int getAsString(String name, String[] out) {
		try {
			mRetVariant.clear();
			int er = mObject.propGet( 0, name, mRetVariant, null );
			if( er < 0 ) return er;

			if( mRetVariant.isVoid() ) return E_MEMBERNOTFOUND;

			if( out != null ) out[0] = mRetVariant.asString();
			mRetVariant.clear();

			return S_OK;
		} catch( TJSException e ) {
			return E_FAIL;
		}
	}

	@Override
	public int getValue(String name, Variant dest) {
		try {
			if( dest == null ) return E_FAIL;
			int er = mObject.propGet( 0, name, dest, null );
			if( er < 0 ) return er;
			return S_OK;
		} catch( TJSException e ) {
			return E_FAIL;
		}
	}

	@Override
	public int getDispatchObject(Holder<Dispatch2> dsp) {
		if( dsp != null ) dsp.mValue = mObject.mObjThis;
		return S_OK;
	}

}
