package jp.kirikiri.tvp2.base;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeInstanceObject;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;

/**
 * AsyncTrigger is a class for invoking events at asynchronous.
 * Script can trigger event but the event is not delivered immediately,
 * is delivered at next event flush phase.
 *
 * TJS AsyncTrigger native instance
 */
public class AsyncTriggerNI extends NativeInstanceObject {
	private static final int atmNormal = 0, atmExclusive = 1, atmAtIdle = 2;

	static private final Variant[] NULL_ARG = new Variant[0];
	static private final int
		E_BADPARAMCOUNT	= -1004,
		S_OK			= 0;
	static private final String ON_FIRE = "onFire";

	private Dispatch2 mOwner;
	private VariantClosure mActionOwner; // object to send action
	private String mActionName;

	private boolean mCached; // cached operation
	private int mMode; // event mode
	private int mIdlePendingCount;

	public AsyncTriggerNI() {
		//mOwner = null;
		mCached = true;
		//mIdlePendingCount = 0;
		mMode = atmNormal;
		mActionOwner = new VariantClosure(null);
		//mActionOwner.mObject = mActionOwner.mObjThis = null;
		mActionName = EventManager.ActionName;
	}
	public int construct( Variant[] param, Dispatch2 tjs_obj) throws TJSException {
		if( param.length < 1) return E_BADPARAMCOUNT;

		int hr = super.construct( param, tjs_obj);
		if( hr < 0 ) return hr;

		if( param.length >= 2 && param[1].isVoid() != true )
			mActionName = param[1].asString(); // action function to be called

		mActionOwner = param[0].asObjectClosure();
		mOwner = tjs_obj;

		return S_OK;
	}
	public void invalidate() throws VariantException, TJSException {
		TVP.EventManager.cancelSourceEvents(mOwner);
		mOwner = null;

		mActionOwner.mObjThis = mActionOwner.mObject = null;
		mActionOwner = null;

		super.invalidate();
	}

	public VariantClosure getActionOwner() { return mActionOwner; }
	public String getActionName() { return mActionName; }

	public void trigger() {
		// trigger event
		if(mOwner!=null) {
			if(mCached) {
				// remove undelivered events from queue when "Cached" flag is set
				TVP.EventManager.cancelSourceEvents(mOwner);
			}

			int flags = EventManager.EPT_POST;
			if(mMode == atmExclusive) flags |= EventManager.EPT_EXCLUSIVE;  // fire exclusive event
			if(mMode == atmAtIdle)    flags |= EventManager.EPT_IDLE;       // fire idle event

			TVP.EventManager.postEvent( mOwner, mOwner, ON_FIRE, 0, flags, NULL_ARG );
		}
	}
	public 	void cancel() {
		// cancel event
		if(mOwner!=null) TVP.EventManager.cancelSourceEvents(mOwner);
		mIdlePendingCount = 0;
	}

	public boolean getCached() { return mCached; }
	public void setCached(boolean b) {
		// set cached operation flag.
		// when this flag is set, only one event is delivered at once.
		if(mCached != b) {
			mCached = b;
			cancel(); // all events are canceled
		}
	}

	public int getMode() { return mMode; }
	public void setMode( int m) {
		if( mMode != m) {
			mMode = m;
			cancel();
		}
	}
}
