package jp.kirikiri.tvp2.base;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeClassProperty;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;

public class AsyncTriggerClass extends NativeClass {

	static private int mClassID = -1;
	static private final int
		E_NATIVECLASSCRASH = -1008,
		S_OK			= 0;
	static private final int
		NIS_GETINSTANCE		= 0x00000002; // get native pointer
	static private final int // enum tTJSNativeInstanceType
		nitMethod	= 1,
		nitProperty = 2;

	static private final String CLASS_NAME = "AsyncTrigger";

	protected NativeInstance createNativeInstance() {
		return new AsyncTriggerNI();
	}

	/*
	private static AsyncTriggerNI getNativeInstance( Dispatch2 objthis ) {
		Holder<NativeInstance> holder = new Holder<NativeInstance>(null);
		int hr = objthis.nativeInstanceSupport( NIS_GETINSTANCE, mClassID, holder );
		if( hr < 0 ) return null;
		return (AsyncTriggerNI) holder.mValue;
	}
	*/

	public AsyncTriggerClass() throws VariantException, TJSException {
		super( CLASS_NAME );
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		// constructor
		registerNCM( CLASS_NAME, new NativeClassConstructor() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				AsyncTriggerNI _this = (AsyncTriggerNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				int hr = _this.construct(param, objthis);
				if( hr < 0 ) return hr;
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		registerNCM( "finalize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "trigger", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				AsyncTriggerNI _this = (AsyncTriggerNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.trigger();
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "cancel", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				AsyncTriggerNI _this = (AsyncTriggerNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.cancel();
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		// event
		registerNCM( "onFire", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				AsyncTriggerNI _this = (AsyncTriggerNI)objthis.getNativeInstance(mClassID);
				VariantClosure obj = _this.getActionOwner();
				if( obj.mObject != null ) {
					String actionname = _this.getActionName();
					if( actionname != null && actionname.length() == 0 ) {
						actionname = null;
					}

					Dispatch2 evobj = EventManager.createEventObject( "onFire", objthis, objthis );
					Variant evval = new Variant(evobj, evobj);
					Variant[] pevval = {evval};
					obj.funcCall( 0, actionname, result, pevval, null );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		registerNCM( "cached", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				AsyncTriggerNI _this = (AsyncTriggerNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getCached() ? 1 : 0 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				AsyncTriggerNI _this = (AsyncTriggerNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setCached( param.asBoolean() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "mode", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				AsyncTriggerNI _this = (AsyncTriggerNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getMode() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				AsyncTriggerNI _this = (AsyncTriggerNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setMode( param.asInteger() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

	}

}
