package jp.kirikiri.tvp2.base;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.UUID;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.env.ApplicationSystem;
import jp.kirikiri.tvp2.utils.DebugClass;
import jp.kirikiri.tvp2.utils.Random;

public class SystemInitializer {

	static private boolean SystemUninitCalled = false;
	static private boolean AtExitShutdown = false;
	static private boolean ProgramArgumentsInit = false;
	static private boolean DataPathDirectoryEnsured = false;

	static private ArrayList<AtExitInfo> AtExitInfos = null;
	static public void initialize() {
		SystemUninitCalled = false;
		AtExitShutdown = false;
		AtExitInfos = new ArrayList<AtExitInfo>();
	}
	static public void systemInitialize() throws TJSException {
		beforeSystemInitialize();

		//ScriptsClass.initScriptEnging();

		afterSystemInit();
	}
	static private void initializeRandomGenerator() {
		// initialize random generator
		Random.updateEnvironNoiseForTick();

		UUID uuid = UUID.randomUUID();
		long l = uuid.getLeastSignificantBits();
        Random.pushEnvironNoise(l);
        long m = uuid.getMostSignificantBits();
		Random.pushEnvironNoise(m);

		// プロセスIDの取得は飛ばす

		long id = Thread.currentThread().getId();
		Random.pushEnvironNoise(id);

		Random.updateEnvironNoiseForTick();

		// カーソル位置からの取得は飛ばす

		// ウィンドウ情報からの取得は飛ばす
	}
	static private void beforeSystemInitialize() throws TJSException {

		//RegisterDllLoadHook(); // register DLL delayed import hook to support _inmm.dll

		initProgramArgumentsAndDataPath(false); // ensure command line

		/*
		Application->HintHidePause = 24*60*60*1000; // not to hide tool tip hint immediately
		Application->ShowHint = false;
		Application->ShowHint = true; // to ensure assigning new HintWindow Class defined in HintWindow.cpp
		*/


		// randomize
		initializeRandomGenerator();

		// memory usage
		{
			Runtime runtime = Runtime.getRuntime();
			long totalMem = runtime.totalMemory();
			long maxMem = runtime.maxMemory();
			long freeMem = runtime.freeMemory();
			Random.pushEnvironNoise(totalMem);
			Random.pushEnvironNoise(maxMem);
			Random.pushEnvironNoise(freeMem);

			TVP.MaxMemory = maxMem;

			DebugClass.addImportantLog( "(info) Max memory : " + maxMem );

			/*
			Variant opt = new Variant();
			if(TVPGetCommandLine( "-memusage", opt) ) {
				String str = opt.asString();
				if( str == "low") TVP.MaxMemory = 0; // assumes zero
			}
			*/

			if( TVP.MaxMemory <= 36*1024*1024 ) {
				// very very low memory, forcing to assume zero memory
				TVP.MaxMemory = 0;
			}

			/*
			if( TVP.MaxMemory < 48*1024*1024 ) {
				// extra low memory
				if( TJSObjectHashBitsLimit > 0) TJSObjectHashBitsLimit = 0;
				TVPSegmentCacheLimit = 0;
				TVPFreeUnusedLayerCache = true; // in LayerIntf.cpp
			} else if( TVP.MaxMemory < 64*1024*1024) {
				// low memory
				if(TJSObjectHashBitsLimit > 4)
					TJSObjectHashBitsLimit = 4;
			}
			*/
		}

		TVP.Application.initializeDataPath();

		if( TVP.ProjectDirSelected ) {
			DebugClass.addImportantLog( "(info) Selected project directory : " + TVP.ProjectDir );
		}
	}
	private static final int
		gsotNone = 0,
		gsotSimple = 1,
		gsotInterlace = 2,
		gsotBiDirection = 3;

	static private void dumpOptions() {
		StringBuilder builder = new StringBuilder(256);
		builder.append( "(info) Specified option(s) (earlier item has more priority) :" );
		boolean appending = false;
		for( Enumeration<?> en = TVP.Properties.propertyNames(); en.hasMoreElements();) {
			String key = (String) en.nextElement();
			String value = TVP.Properties.getProperty(key);
			builder.append( " -" );
			builder.append( key );
			builder.append( '=' );
			builder.append( value );
			appending = true;
		}
		if( appending == false ) {
			builder.append( " (none)" );
		}
		DebugClass.addImportantLog(builder.toString());
		builder = null;
	}
	private static void afterSystemInit() {
		// ensure datapath directory
		// ensureDataPathDirectory();

		// determine maximum graphic cache limit

		// オプション見てタイマースレッドの優先度を変える
		int limitmb = -1;
		String prop = TVP.Properties.getProperty("gclim","auto");
		if( !"auto".equals(prop) ) {
			limitmb = Integer.valueOf(prop);
		}

		// TVP.MaxMemory は VM のヒープなので、画像が読み込まれるヒープとは違う
		// Android だと常に 0 になってしまうはず
		if(limitmb == -1) {
			if( TVP.MaxMemory <= 32*1024*1024)
				TVP.GraphicCacheSystemLimit = 0;
			else if(TVP.MaxMemory <= 48*1024*1024)
				TVP.GraphicCacheSystemLimit = 0;
			else if(TVP.MaxMemory <= 64*1024*1024)
				TVP.GraphicCacheSystemLimit = 0;
			else if(TVP.MaxMemory <= 96*1024*1024)
				TVP.GraphicCacheSystemLimit = 4;
			else if(TVP.MaxMemory <= 128*1024*1024)
				TVP.GraphicCacheSystemLimit = 8;
			else if(TVP.MaxMemory <= 192*1024*1024)
				TVP.GraphicCacheSystemLimit = 12;
			else if(TVP.MaxMemory <= 256*1024*1024)
				TVP.GraphicCacheSystemLimit = 20;
			else if(TVP.MaxMemory <= 512*1024*1024)
				TVP.GraphicCacheSystemLimit = 40;
			else
				TVP.GraphicCacheSystemLimit = (TVP.MaxMemory / (1024*1024*10));	// cachemem = physmem / 10
			TVP.GraphicCacheSystemLimit *= 1024*1024;
		} else {
			TVP.GraphicCacheSystemLimit = limitmb * 1024*1024;
		}

		/*
		if( TVP.MaxMemory <= 64*1024*1024)
			TVP.setFontCacheForLowMem();
		*/

		// check TVPGraphicSplitOperation option
		prop = TVP.Properties.getProperty("gsplit","yes");
		if( "no".equals(prop) )
			TVP.GraphicSplitOperationType = gsotNone;
		else if( "int".equals(prop) )
			TVP.GraphicSplitOperationType = gsotInterlace;
		else if( "yes".equals(prop) || "simple".equals(prop) )
			TVP.GraphicSplitOperationType = gsotSimple;
		else if( "bidi".equals(prop) )
			TVP.GraphicSplitOperationType = gsotBiDirection;


		// check TVPDefaultHoldAlpha option
		prop = TVP.Properties.getProperty("holdalpha","false");
		if( "yes".equals(prop) || "true".equals(prop) )
			TVP.DefaultHoldAlpha = true;
		else
			TVP.DefaultHoldAlpha = false;

		// JPEG デコーダー精度は無視

		// dump option
		dumpOptions();

		// timer 精度は無視

		// draw thread 数は無視(常に自動)
	}

	static void initProgramArgumentsAndDataPath( boolean stop_after_datapath_got ) throws TJSException {
		if(!ProgramArgumentsInit) {
			ProgramArgumentsInit = true;

			TVP.Application.initializeSaveDataPath( stop_after_datapath_got );
		}
	}

	/**
	 * システム終了処理
	 */
	public static void systemUninitialize() {
		if(SystemUninitCalled) return;
		SystemUninitCalled = true;

		try {
			ScriptsClass.uninitScriptEngine();
		} catch( Exception e )  {
			// ignore errors
		}
		causeAtExit();
	}

	static class AtExitInfo {
		private int mPriority;
		private Runnable mHandler;

		public AtExitInfo( int pri, Runnable e ) {
			mPriority = pri;
			mHandler = e;
		}
		public final void doRun() {
			mHandler.run();
		}
		public final int getPriority() { return mPriority; }
	}
	static class AtExitInfoComparator implements Comparator<AtExitInfo> {
		@Override
		public int compare(AtExitInfo o1, AtExitInfo o2) {
			return o1.getPriority() - o2.getPriority();
		}
	}
	private static void causeAtExit() {
		if( AtExitShutdown) return;
		AtExitShutdown = true;

		if( AtExitInfos != null ) {
			Collections.sort(AtExitInfos, new AtExitInfoComparator());
			final int count = AtExitInfos.size();
			for( int i = 0; i < count; i++ ) {
				AtExitInfos.get(i).doRun();
			}
			AtExitInfos = null;
		}
	}
	public static void ensureDataPathDirectory() {
		if(!DataPathDirectoryEnsured) {
			DataPathDirectoryEnsured = true;
			// ensure data path existence
			if( Storage.checkExistentLocalFolder(TVP.NativeDataPath) == false ) {
				if( Storage.createFolders( TVP.NativeDataPath ) )
					DebugClass.addImportantLog("(info) Data path does not exist, trying to make it ... ok.");
				else
					DebugClass.addImportantLog("(info) Data path does not exist, trying to make it ... failed.");
			}
		}
	}
}
