package jp.kirikiri.tjs2;

import jp.kirikiri.tvp2.msg.Message;

public interface SourceCodeAccessor {

	/**
	 * バイトコード位置からソースコード位置を得る
	 * @param codepos バイトコード位置
	 * @return ソースコード位置
	 */
	public int codePosToSrcPos( int codepos );

	/**
	 * ソースコード位置から行数を得る
	 * @param srcpos ソースコード位置
	 * @return 行数
	 */
	public int srcPosToLine( int srcpos );

	/**
	 * 指定ラインの文字列を得る
	 * @param line 行数
	 * @return 指定行の文字列
	 */
	public String getLine( int line );

	/**
	 * スクリプトを全文取得する
	 * @return スクリプト文
	 */
	public String getScript();

	/**
	 * スクリプト開始オフセットを取得する
	 * @return オフセット
	 */
	public int getLineOffset();

	/**
	 * スクリプト名を取得する
	 * @return スクリプト名
	 */
	public String getName();
}
