package jp.kirikiri.tjs2;

public class ScriptLineData {

	private final String mString;

	private IntVector mLineVector;
	private IntVector mLineLengthVector;
	private int mLineOffset;

	static private final int CARRIAGE_RETURN = 13;
	static private final int LINE_FEED = 10;

	public ScriptLineData( String string ) {
		mString = string;
	}

	private final void generateLineVector() {
		mLineVector = new IntVector();
		mLineLengthVector = new IntVector();
		int count = mString.length();
		int lastCR = 0;
		int i;
		for( i= 0; i < count; i++ ) {
			int c = mString.charAt(i);
			if( c == CARRIAGE_RETURN || c == LINE_FEED ) {
				mLineVector.add( lastCR );
				mLineLengthVector.add( i-lastCR );
				lastCR = i+1;
				if( (i+1) < count ) {
					c = mString.charAt(i+1);
					if( c == CARRIAGE_RETURN || c == LINE_FEED ) {
						i++;
						lastCR = i+1;
					}
				}
			}
		}
		if( i != lastCR ) {
			mLineVector.add( lastCR );
			mLineLengthVector.add( i-lastCR );
		}
	}
	public final int getSrcPosToLine( int pos ) {
		if( mLineVector == null ) {
			generateLineVector();
		}
		// 2分法によって位置を求める
		int s = 0;
		int e = mLineVector.size();
		while( true ) {
			if( (e-s) <= 1 ) return s + mLineOffset;
			int m = s + (e-s)/2;
			if( mLineVector.get(m) > pos )
				e = m;
			else
				s = m;
		}
	}
	public final int getLineToSrcPos( int pos ) {
		if( mLineVector == null ) {
			generateLineVector();
		}
		return mLineVector.get(pos);
	}
	public final String getLine( int line ) {
		if( mLineVector == null ) {
			generateLineVector();
		}
		int start = mLineVector.get(line);
		int length = mLineLengthVector.get(line);
		return mString.substring(start, start+length );
	}
	public final int getMaxLine() {
		if( mLineVector == null ) {
			generateLineVector();
		}
		return mLineVector.size();
	}
}
