package jp.kirikiri.tvp2.base;

import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeClassProperty;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tjs2.Dispatch2;

public class SystemClass extends NativeClass {
	static private int mClassID = -1;
	static private final int
		E_MEMBERNOTFOUND = -1001,
		E_NOTIMPL		= -1002,
		E_BADPARAMCOUNT	= -1004,
		E_INVALIDOBJECT	= -1006,
		E_ACCESSDENYED	= -1007,
		E_NATIVECLASSCRASH = -1008,
		S_OK			= 0,
		S_TRUE			= 1;
	private static final int
		MEMBERENSURE		= 0x00000200, // create a member if not exists
		MEMBERMUSTEXIST     = 0x00000400, // member *must* exist ( for Dictionary/Array )
		IGNOREPROP			= 0x00000800, // ignore property invoking
		HIDDENMEMBER		= 0x00001000, // member is hidden
		STATICMEMBER		= 0x00010000, // member is not registered to the
										  // object (internal use)
		ENUM_NO_VALUE		= 0x00100000; // values are not retrieved
										  // (for EnumMembers)
	static private final int
		NIS_GETINSTANCE		= 0x00000002; // get native pointer
	static private final String CLASS_NAME = "System";
	static private final int nitMethod	= 1, nitProperty = 2;


	protected NativeInstance createNativeInstance() {
		// this class cannot create an instance
		// TODO 後で実装する
		// TVPThrowExceptionMessage(TVPCannotCreateInstance);
		return null;
	}

	public SystemClass() throws VariantException, TJSException {
		super(CLASS_NAME);
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;


		// constructor
		registerNCM( CLASS_NAME, new NativeClassConstructor() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		registerNCM( "finalize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "terminate", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "exit", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "inputString", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "addContinuousHandler", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "removeContinuousHandler", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "toActualColor", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "clearGraphicCache", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "touchImages", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "createUUID", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "assignMessage", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "doCompact", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "inform", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "getTickCount", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "getKeyState", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "shellExecute", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "system", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "readRegValue", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "getArgument", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "setArgument", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "createAppLock", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "nullpo", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );



		registerNCM( "versionString", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "versionInformation", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "eventDisabled", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "graphicCacheLimit", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "platformName", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "osName", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "exitOnWindowClose", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "drawThreadNum", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "processorNum", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "exitOnNoWindowStartup", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "exePath", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "personalPath", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "appDataPath", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "dataPath", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "exeName", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "title", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "screenWidth", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "screenHeight", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "desktopLeft", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "desktopTop", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "desktopWidth", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "desktopHeight", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "stayOnTop", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );


		// register default "exceptionHandler" member
		Variant val = new Variant( null, null );
		propSet( MEMBERENSURE, "exceptionHandler", val, this);

		// and onActivate, onDeactivate
		propSet( MEMBERENSURE, "onActivate", val, this);
		propSet( MEMBERENSURE, "onDeactivate", val, this);
	}
}
