package jp.kirikiri.tjs2;

public abstract class NativeClassMethod extends Dispatch {
	private static final int S_TRUE = 1;
	private static final int E_NATIVECLASSCRASH = -1008;

	public int isInstanceOf( int flag, final String membername, final String classname, Dispatch2 objthis ) throws VariantException, TJSException {
		if( membername == null ) {
			if( "Function".equals(classname) ) return S_TRUE;
		}
		return super.isInstanceOf(flag, membername, classname, objthis);
	}
	public int funcCall( int flag, final String membername, Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException, TJSException {
		if( membername != null ) return super.funcCall(flag, membername, result, param, objthis);
		if( objthis == null ) return E_NATIVECLASSCRASH;
		if( result != null ) result.clear();

		return process( result, param, objthis );
	}
	// override this instead of FuncCall
	abstract protected int process( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException, TJSException;
}
