/**
 ******************************************************************************
 * Copyright (c), Takenori Imoto
 *  software http://www.kaede-software.com/
 * All rights reserved.
 ******************************************************************************
 * \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏
 * ꍇɌAĔЕzюgp܂B
 *
 * E\[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐ
 *   ܂߂邱ƁB
 * EoCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL
 *   쌠\A{ꗗAщLƐӏ܂߂邱ƁB
 * Eʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔
 *   iɁAgD̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB
 *
 * {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v
 * ĂAَ킸AƓIȎgp\Aѓ̖ړIɑ΂K
 * ɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂
 * B쌠҂Rgr[^[AR̂킸AQ̌
 * 킸AӔC̍_ł邩iӔCł邩iߎ̑́js@
 * sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂ
 * ĂA{\tgEFA̎gpɂĔi֕i܂͑pT[rX̒BA
 * gp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳
 * jڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQ
 * āAؐӔC𕉂Ȃ̂Ƃ܂B
 ******************************************************************************
 * {\tgEFÁAgg2 ( http://kikyou.info/tvp/ ) ̃\[XR[hJava
 * ɏ̂ꕔgpĂ܂B
 * gg2 Copyright (C) W.Dee <dee@kikyou.info> and contributors
 ******************************************************************************
 */
package jp.kirikiri.tjs2;

import java.util.ArrayList;

public class DictionaryClass extends NativeClass {

	static public int ClassID = -1;
	static private final String CLASS_NAME = "Dictionary";

	protected NativeInstance createNativeInstance() {
		return new DictionaryNI();
	}
	protected Dispatch2 createBaseTJSObject() {
		return new DictionaryObject();
	}

	public DictionaryClass() throws VariantException, TJSException {
		super(CLASS_NAME);
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		ClassID = NCM_CLASSID;

		// constructor
		registerNCM( CLASS_NAME, new NativeClassConstructor() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				DictionaryNI _this = (DictionaryNI)objthis.getNativeInstance( ClassID );
				if( _this == null ) return Error.E_NATIVECLASSCRASH;
				int hr = _this.construct( param, objthis );
				if( hr < 0 ) return hr;

				return Error.S_OK;
			}
		}, CLASS_NAME, Interface.nitMethod, Interface.STATICMEMBER );

		registerNCM( "load", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				DictionaryNI ni = (DictionaryNI)objthis.getNativeInstance(ClassID);
				if( ni == null ) return Error.E_NATIVECLASSCRASH;
				if( !ni.isValid() ) return Error.E_INVALIDOBJECT;
				// OribinalTODO: implement Dictionary.load()
				return Error.S_OK;
			}
		}, CLASS_NAME, Interface.nitMethod, Interface.STATICMEMBER );

		registerNCM( "save", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				DictionaryNI ni = (DictionaryNI)objthis.getNativeInstance(ClassID);
				if( ni == null ) return Error.E_NATIVECLASSCRASH;
				if( !ni.isValid() ) return Error.E_INVALIDOBJECT;
				// OribinalTODO: implement Dictionary.save()
				return Error.S_OK;
			}
		}, CLASS_NAME, Interface.nitMethod, Interface.STATICMEMBER );

		registerNCM( "saveStruct", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				// Structured output for flie;
				// the content can be interpret as an expression to re-construct the object.
				DictionaryNI ni = (DictionaryNI)objthis.getNativeInstance(ClassID);
				if( ni == null ) return Error.E_NATIVECLASSCRASH;
				if( !ni.isValid() ) return Error.E_INVALIDOBJECT;
				if( param.length < 1) return Error.E_BADPARAMCOUNT;

				String name = param[0].asString();
				String mode = null;
				if( param.length >= 2 && param[1].isVoid() != true ) mode = param[1].asString();

				TextWriteStreamInterface stream = TJS.mStorage.createTextWriteStream(name, mode);
				try {
					ArrayList<Dispatch2> stack = new ArrayList<Dispatch2>();
					stack.add(objthis);
					ni.saveStructuredData( stack, stream, "" );
				} finally {
					stream.destruct();
				}
				if( result != null ) result.set( new Variant(objthis, objthis) );
				return Error.S_OK;
			}
		}, CLASS_NAME, Interface.nitMethod, Interface.STATICMEMBER );

		registerNCM( "assign", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				DictionaryNI ni = (DictionaryNI)objthis.getNativeInstance(ClassID);
				if( ni == null ) return Error.E_NATIVECLASSCRASH;
				if( !ni.isValid() ) return Error.E_INVALIDOBJECT;
				if( param.length < 1) return Error.E_BADPARAMCOUNT;

				boolean clear = true;
				if( param.length >= 2 && param[1].isVoid() != true ) clear = param[1].asBoolean();

				VariantClosure clo = param[0].asObjectClosure();
				if( clo.mObjThis != null )
					ni.assign(clo.mObjThis, clear);
				else if( clo.mObject != null )
					ni.assign(clo.mObject, clear);
				else throw new TJSException(Error.NullAccess);
				return Error.S_OK;
			}
		}, CLASS_NAME, Interface.nitMethod, Interface.STATICMEMBER );

		registerNCM( "assignStruct", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				DictionaryNI ni = (DictionaryNI)objthis.getNativeInstance(ClassID);
				if( ni == null ) return Error.E_NATIVECLASSCRASH;
				if( !ni.isValid() ) return Error.E_INVALIDOBJECT;
				if( param.length < 1) return Error.E_BADPARAMCOUNT;

				ArrayList<Dispatch2> stack = new ArrayList<Dispatch2>();
				VariantClosure clo = param[0].asObjectClosure();
				if( clo.mObjThis != null )
					ni.assignStructure( clo.mObjThis, stack );
				else if( clo.mObject != null )
					ni.assignStructure(clo.mObject, stack);
				else throw new TJSException(Error.NullAccess);
				return Error.S_OK;
			}
		}, CLASS_NAME, Interface.nitMethod, Interface.STATICMEMBER );

		registerNCM( "clear", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				DictionaryNI ni = (DictionaryNI)objthis.getNativeInstance(ClassID);
				if( ni == null ) return Error.E_NATIVECLASSCRASH;
				if( !ni.isValid() ) return Error.E_INVALIDOBJECT;
				ni.clear();
				return Error.S_OK;
			}
		}, CLASS_NAME, Interface.nitMethod, Interface.STATICMEMBER );
	}

}
