package jp.kirikiri.tvp2.env;

import jp.kirikiri.tjs2.Error;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.visual.DivisibleTransHandler;
import jp.kirikiri.tvp2.visual.ScanLineProvider;
import jp.kirikiri.tvp2.visual.SimpleOptionProvider;

/**
 * 回転を行うトランジションハンドラ基底クラスの実装
 */
public abstract class BaseRotateTransHandler implements DivisibleTransHandler {

	protected long mStartTick; // トランジションを開始した tick count
	protected long mTime; // トランジションに要する時間
	protected long mCurTime; // 現在の時間
	protected int mWidth; // 処理する画像の幅
	protected int mHeight; // 処理する画像の高さ
	protected int mBGColor; // 背景色
	protected int mPhase; // アニメーションのフェーズ
	protected boolean mFirst; // 一番最初の呼び出しかどうか

	public BaseRotateTransHandler( long time, int width, int height, int bgcolor ) {
		mWidth = width;
		mHeight = height;
		mTime = time;
		mBGColor = bgcolor | 0xff000000;

		//mDrawData = new RotateDrawData[height];

		mFirst = true;
	}
	@Override
	public int setOption(SimpleOptionProvider options) {
		return Error.S_OK;
	}

	/**
	 * トランジションの画面更新一回ごとに呼ばれる
	 *
	 * トランジションの画面更新一回につき、まず最初に StartProcess が呼ばれる
	 * そのあと Process が複数回呼ばれる ( 領域を分割処理している場合 )
	 * 最後に EndProcess が呼ばれる
	 */
	@Override
	public int startProcess(long tick) {
		if( mFirst ) {
			// 最初の実行
			mFirst = false;
			mStartTick = tick;
		}

		// 画像演算に必要なパラメータを計算
		mCurTime = (tick - mStartTick);
		if(mCurTime > mTime) mCurTime = mTime;

		/*
		// データをクリア
		for( int i = 0; i < mHeight; i++) {
			// 背景でクリア
			DrawData[i].count = 1;
			DrawData[i].region[0].left = 0;
			DrawData[i].region[0].right = mWidth;
			DrawData[i].region[0].type = 0; // 0 = 背景
		}
		*/

		calcPosition(); // 下位クラスの CalcPosition メソッドを呼ぶ
		return Error.S_TRUE;
	}

	/**
	 * トランジションの画面更新一回分が終わるごとに呼ばれる
	 */
	@Override
	public int endProcess() {
		if(mCurTime == mTime) return Error.S_FALSE; // トランジション終了
		return Error.S_TRUE;
	}

	@Override
	public int makeFinalImage(ScanLineProvider dest, ScanLineProvider src1, ScanLineProvider src2) throws TJSException {
		// final image is the source2 bitmap
		dest.copyFrom( src2 );
		return Error.S_OK;
	}

	abstract void calcPosition();
}
