/**
 ******************************************************************************
 * Copyright (c), Takenori Imoto
 *  software http://www.kaede-software.com/
 * All rights reserved.
 ******************************************************************************
 * \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏
 * ꍇɌAĔЕzюgp܂B
 *
 * E\[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐ
 *   ܂߂邱ƁB
 * EoCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL
 *   쌠\A{ꗗAщLƐӏ܂߂邱ƁB
 * Eʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔
 *   iɁAgD̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB
 *
 * {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v
 * ĂAَ킸AƓIȎgp\Aѓ̖ړIɑ΂K
 * ɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂
 * B쌠҂Rgr[^[AR̂킸AQ̌
 * 킸AӔC̍_ł邩iӔCł邩iߎ̑́js@
 * sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂ
 * ĂA{\tgEFA̎gpɂĔi֕i܂͑pT[rX̒BA
 * gp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳
 * jڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQ
 * āAؐӔC𕉂Ȃ̂Ƃ܂B
 ******************************************************************************
 * {\tgEFÁAgg2 ( http://kikyou.info/tvp/ ) ̃\[XR[hJava
 * ɏ̂ꕔgpĂ܂B
 * gg2 Copyright (C) W.Dee <dee@kikyou.info> and contributors
 ******************************************************************************
 */
package jp.kirikiri.tjs2;

class SymbolData {

	static private final int
		SYMBOL_INIT = 0x2,
		SYMBOL_USING = 0x1;

	public String	mName;
	public int		mHash;
	public int		mSymFlags;
	public int		mFlags;
	public Variant	mValue;
	public SymbolData mNext;

	public void selfClear() {
		mName = null;
		mHash = 0;
		mFlags = 0;
		mValue = new Variant();
		mNext = null;
		mSymFlags = SYMBOL_INIT;
	}
	private void setNameInternal( String name ) throws TJSException {
		if( name == null ) throw new TJSException( Error.IDExpected );
		if( name.length() == 0 ) throw new TJSException( Error.IDExpected );
		if( mName != null && mName.equals(name) ) return;
		//mName = new String( name );
		mName = name;
	}
	public void setName( String name, int hash ) throws TJSException {
		// setNameInternal(name);
		mHash = hash;

		if( mName != null && mName.equals(name) ) return;
		if( name == null ) throw new TJSException( Error.IDExpected );
		if( name.length() == 0 ) throw new TJSException( Error.IDExpected );
		mName = name;
	}
	public final String getName() { return mName; }
	public void postClear() {
		mName = null;
		mValue = null;
		mValue = new Variant();
		mSymFlags &= ~SYMBOL_USING;
	}
	public void destory() {
		mName = null;
		mValue = null;
	}
	public boolean nameMatch( final String name ) {
		if( mName == name ) return true;
		//return mName != null && mName.equals( name );
		return mName.equals( name );
	}
	public void reShare() {
		// search shared string map using mapGlobalStringMap,
		// and ahsre the name string ( if it can )
		if( mName != null ) {
			mName = TJS.mapGlobalStringMap( mName );
		}
	}
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder(32);
		if( mName != null ) {
			builder.append(mName);
			builder.append(" : ");
		} else {
			builder.append("no name : ");
		}
		if( mValue != null ) builder.append(mValue.toString());
		else builder.append("empty");
		return builder.toString();
	}
}

