package jp.kirikiri.tvp2env;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;

import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.base.ByteBufferInputStream;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.msg.Message;

public class MouseCursor {
	static public final int
	crDefault = 0x0,
	crNone = -1,
	crArrow = -2,
	crCross = -3,
	crIBeam = -4,
	crSize = -5,
	crSizeNESW = -6,
	crSizeNS = -7,
	crSizeNWSE = -8,
	crSizeWE = -9,
	crUpArrow = -10,
	crHourGlass = -11,
	crDrag = -12,
	crNoDrop = -13,
	crHSplit = -14,
	crVSplit = -15,
	crMultiDrag = -16,
	crSQLWait = -17,
	crNo = -18,
	crAppStart = -19,
	crHelp = -20,
	crHandPoint = -21,
	crSizeAll = -22,
	crHBeam = 1;

	private HashMap<String, Integer> mCursorTable;
	private int mCursorCount;
	private ArrayList<Cursor> mCursors;
	private Cursor mNullCursor;

	private HashMap<Integer, Cursor> mInternalCursor;
	public MouseCursor() {
		mCursorTable = new HashMap<String,Integer>();
		mCursorCount = 1;
		mCursors = new ArrayList<Cursor>();
		mCursors.add(null);

		mInternalCursor = new HashMap<Integer, Cursor>();

		BufferedImage image = new BufferedImage(32, 32, BufferedImage.TYPE_4BYTE_ABGR);
		mNullCursor = Toolkit.getDefaultToolkit().createCustomCursor( image, new Point(16,16),"trans");

		// 未定義のカーソル画像をどうするか……
		//Toolkit.getDefaultToolkit()
	}
	private Cursor getInternalCursor(int v) {
		switch(v) {
		case crDefault:
			return Cursor.getDefaultCursor();
		case crArrow:
			return Cursor.getDefaultCursor();
		case crCross:
			return Cursor.getPredefinedCursor( Cursor.CROSSHAIR_CURSOR );
		case crIBeam:
			return Cursor.getPredefinedCursor( Cursor.TEXT_CURSOR );
		case crHourGlass:
			return Cursor.getPredefinedCursor( Cursor.WAIT_CURSOR );
		case crUpArrow:
			return Cursor.getPredefinedCursor( Cursor.N_RESIZE_CURSOR );
		case crHandPoint:
			return Cursor.getPredefinedCursor( Cursor.HAND_CURSOR );
		case crSize:
			return Cursor.getPredefinedCursor( Cursor.MOVE_CURSOR );
		case crNone:
			return mNullCursor;
		case -36:
			return Cursor.getPredefinedCursor( Cursor.E_RESIZE_CURSOR );
		case -35:
			return Cursor.getPredefinedCursor( Cursor.W_RESIZE_CURSOR );
		case -34:
			return Cursor.getPredefinedCursor( Cursor.S_RESIZE_CURSOR );
		case -33:
			return Cursor.getPredefinedCursor( Cursor.NE_RESIZE_CURSOR );
		case -32:
			return Cursor.getPredefinedCursor( Cursor.NW_RESIZE_CURSOR );
		case -31:
			return Cursor.getPredefinedCursor( Cursor.SE_RESIZE_CURSOR );
		case -30:
			return Cursor.getPredefinedCursor( Cursor.SW_RESIZE_CURSOR );
		}
		return null;
	}
	public Cursor getCursor( int v ) {
		Cursor c = mInternalCursor.get(v);
		if( c != null ) {
			return c;
		} else {
			return getInternalCursor(v);
		}
	}
	public int getCursor( WindowForm win, final String name ) throws TJSException {
		// get placed path
		String place = Storage.searchPlacedPath(name);

		// search in cache
		Integer in_hash = mCursorTable.get(place);
		if(in_hash!=null) return in_hash.intValue();

		// not found
		BinaryStream stream = Storage.createStream(place,0);
		long size = stream.getSize();
		ByteBuffer buff = ByteBuffer.allocateDirect((int)size);
		stream.read(buff);
		stream.close();
		buff.flip();
		ByteBufferInputStream input = new ByteBufferInputStream(buff);
		BufferedImage img = NativeImageLoader.loadImage(input);
		if( img == null ) Message.throwExceptionMessage(Message.CannotLoadCursor, place);

		Cursor c = win.getToolkit().createCustomCursor( img, new Point(img.getWidth()/2,img.getHeight()/2), name );

		mCursorCount++;
		mCursors.add( mCursorCount, c);
		mCursorTable.put(place, mCursorCount);
		mInternalCursor.put( mCursorCount, c );
		return mCursorCount;
	}
}
