package jp.kirikiri.tjs2;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;

public class MersenneTwisterData {
	private static final int MT_N = 624;

	public int left;
	public int next;	// index a value in 'state'
	public LongBuffer state; // the array for the state vector

	public MersenneTwisterData() {
		ByteBuffer buff = ByteBuffer.allocateDirect(MT_N*8);
		buff.order( ByteOrder.nativeOrder() );
		state = buff.asLongBuffer();
		state.clear();
		state.position(0);
		state.limit(MT_N);
	}
}
