package jp.kirikiri.tjs2;

public class DictionaryObject extends CustomObject {
	private static Variant VoidVal;
	public static void initialize() {
		VoidVal = new Variant();
	}
	public static void finalizeApplication() {
		VoidVal = null;
	}
	public DictionaryObject() {
		super();
		mCallFinalize = false;
	}
	/*
	public int funcCall( int flag, final String membername, Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException, TJSException {
		return super.funcCall(flag, membername, result, param, objthis);
	}
	*/

	public int propGet( int flag, final String membername, Variant result, Dispatch2 objthis ) throws VariantException, TJSException {
		int hr = super.propGet(flag, membername, result, objthis);
		if( hr == Error.E_MEMBERNOTFOUND && (flag & Interface.MEMBERMUSTEXIST) == 0) {
			if(result != null) result.clear(); // returns void
			return Error.S_OK;
		}
		return hr;
	}
	public int createNew( int flag, final String membername, Holder<Dispatch2> result, Variant[] param, Dispatch2 objthis ) throws VariantException, TJSException {
		int hr = super.createNew(flag, membername, result, param, objthis);
		if( hr == Error.E_MEMBERNOTFOUND && (flag & Interface.MEMBERMUSTEXIST) == 0 )
			return Error.E_INVALIDTYPE; // call operation for void
		return hr;
	}
	public int operation( int flag, final String membername, Variant result, final Variant param, Dispatch2 objthis ) throws VariantException, TJSException {
		int hr = super.operation(flag, membername, result, param, objthis);
		if( hr == Error.E_MEMBERNOTFOUND && (flag & Interface.MEMBERMUSTEXIST) == 0 ) {
			// value not found -> create a value, do the operation once more
			hr = super.propSet( Interface.MEMBERENSURE, membername, VoidVal, objthis);
			if( hr < 0 ) return hr;
			hr = super.operation(flag, membername, result, param, objthis);
		}
		return hr;
	}
}
