<?php
	// Copyright (c) 2008, u6k.yu1@gmail.com
	// All rights reserved.
	// 
	// Redistribution and use in source and binary forms, with or without
	// modification, are permitted provided that the following conditions are met:
	//     * Redistributions of source code must retain the above copyright
	//       notice, this list of conditions and the following disclaimer.
	//     * Redistributions in binary form must reproduce the above copyright
	//       notice, this list of conditions and the following disclaimer in the
	//       documentation and/or other materials provided with the distribution.
	//     * Neither the name of the u6k nor the
	//       names of its contributors may be used to endorse or promote products
	//       derived from this software without specific prior written permission.
	// 
	// THIS SOFTWARE IS PROVIDED BY u6k.yu1@gmail.com ``AS IS'' AND ANY
	// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
	// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
	// DISCLAIMED. IN NO EVENT SHALL u6k.yu1@gmail.com BE LIABLE FOR ANY
	// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
	// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	
	require_once(dirname(__FILE__) . "/../../../main/php/common/common.php");
	require_once(dirname(__FILE__) . "/../../../main/php/logic/Hirameki_ArticleLogic.php");
	require_once("PHPUnit/Framework.php");
	require_once("MDB2.php");
	
	class ArticleTest extends PHPUnit_Framework_TestCase {
		public function setUp() {
			global $config;
			$con = MDB2::connect($config["dsn"]);
			$con->loadModule("Manager");
			
			$con->nextID("article_id");
			$con->dropSequence("article_id");
			
			$con->exec("delete from article");
			
			$con->disconnect();
		}
		
		public function queryAll($sql, $types) {
			global $config;
			$con = MDB2::connect($config["dsn"]);
			$con->setFetchMode(MDB2_FETCHMODE_ASSOC);
			
			$result = $con->queryAll($sql, $types);
			
			$con->disconnect();
			
			return $result;
		}
		
		public function testCreateArticle_AddArticle() {
			Hirameki_ArticleLogic::create(0, "ほげ", "ほげほげーーー", "ほげタグ ほげ");
			
			$expected_articles = array(array(
				"id" => 1,
				"title" => "ほげ",
				"content" => "ほげほげーーー",
				"tag" => "ほげタグ ほげ"
			));
			$actual_articles = $this->queryAll("select id, title, content from article order by id", array("integer", "text", "text"));
			
			$this->assertTrue($expected_articles === $actual_articles, true);
		}
		
		public function testCreateArticle_ManyAddArticle() {
			Hirameki_ArticleLogic::create(0, "ほげ1", "ほげほげ\nほげー", NULL);
			Hirameki_ArticleLogic::create(0, "ほげ2", "ほげほげ\nhoge------", NULL);
			Hirameki_ArticleLogic::create(0, "ほげ3", "uryyy!!!!", NULL);
			
			$expected_articles = array();
			$expected_articles[] = array(
				"id" => 1,
				"title" => "ほげ1",
				"content" => "ほげほげ\nほげー"
			);
			$expected_articles[] = array(
				"id" => 2,
				"title" => "ほげ2",
				"content" => "ほげほげ\nhoge------"
			);
			$expected_articles[] = array(
				"id" => 3,
				"title" => "ほげ3",
				"content" => "uryyy!!!!"
			);
			$actual_articles = $this->queryAll("select id, title, content from article order by id", array("integer", "text", "text"));
			$this->assertTrue($expected_articles === $actual_articles);
		}
	}
?>
