<?php
	require_once("PHPUnit/Framework.php");
	require_once("HTTP/Client.php");
	require_once("MDB2.php");
	require_once("Config.php");
	
	class ArticleListTest extends PHPUnit_Framework_TestCase {
		public function setUp() {
			$conf = new Config();
			$config = $conf->parseConfig(dirname(__FILE__) . "/../../main/php/config/config.xml", "XML");
			$settings = $config->toArray();
			
			$con = MDB2::connect($settings["root"]["config"]["dsn"]);
			$con->loadModule("Manager");
			
			$con->nextID("article_id");
			$con->dropSequence("article_id");
			
			$con->exec("delete from article");
			
			$con->disconnect();
		}
		
		public function testNonItem() {
			$httpclient = new HTTP_Client();
			$responseCode = $httpclient->get("http://localhost/hirameki-note/article_list.php");
			$response = $httpclient->currentResponse();
			
			$expected_html = file_get_contents(dirname(__FILE__) . "/article_list_noitem.html");
			
			$this->assertEquals(200, $responseCode);
			$this->assertEquals($expected_html, $response["body"]);
		}
	}
?>
