<?php
	// Copyright (c) 2008, u6k.yu1@gmail.com
	// All rights reserved.
	// 
	// Redistribution and use in source and binary forms, with or without
	// modification, are permitted provided that the following conditions are met:
	//     * Redistributions of source code must retain the above copyright
	//       notice, this list of conditions and the following disclaimer.
	//     * Redistributions in binary form must reproduce the above copyright
	//       notice, this list of conditions and the following disclaimer in the
	//       documentation and/or other materials provided with the distribution.
	//     * Neither the name of the u6k nor the
	//       names of its contributors may be used to endorse or promote products
	//       derived from this software without specific prior written permission.
	// 
	// THIS SOFTWARE IS PROVIDED BY u6k.yu1@gmail.com ``AS IS'' AND ANY
	// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
	// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
	// DISCLAIMED. IN NO EVENT SHALL u6k.yu1@gmail.com BE LIABLE FOR ANY
	// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
	// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	
	require_once("error.php");
	
	/**
	 * 日付・時刻に関連する機能を提供します。
	 * 
	 * 日付・時刻は扱いに注意が必要な型です。
	 * ひらめきノートで日付・時刻を扱う場合、必ず{@link Hirameki_DateTimeUtil}クラスを通して扱います。
	 * 
	 * @package common
	 * @author u6k <u6k.yu1@gmail.com>
	 * @copyright Copyright (c) 2008 u6k.yu1@gmail.com, All rights reserved.
	 * @license BSD License
	 * @version $Id$
	 * @link http://hirameki-note.sourceforge.jp/ ひらめきノート
	 */
	class Hirameki_DateTimeUtil {
		/**
		 * 現在日時を返します。
		 * 
		 * 実際は、32bitの整数値を返します。
		 * この整数値はエポック秒です。
		 * 
		 * @param void
		 * @return 現在日時。
		 */
		public static function now() {
			return time(); // TODO 32bit整数値であり、2037年までしか扱えません。改善する必要があります。
		}
		
		/**
		 * 日時に書式を適用して、文字列に変換して返します。
		 * 
		 * 書式は、ユーザごとに設定でき、このメソッドはそのユーザごとの書式で日時を文字列に変換します。
		 * 
		 * @param int $time 文字列に変換する日時。
		 * @return 日時から変換した文字列。
		 */
		public static function format($time) {
			return date("Y-m-d H:i:s", $time); // TODO ユーザごとの書式で変換するようにします。
		}
	}
?>
