<?php
	// Copyright (c) 2008, u6k.yu1@gmail.com
	// All rights reserved.
	// 
	// Redistribution and use in source and binary forms, with or without
	// modification, are permitted provided that the following conditions are met:
	//     * Redistributions of source code must retain the above copyright
	//       notice, this list of conditions and the following disclaimer.
	//     * Redistributions in binary form must reproduce the above copyright
	//       notice, this list of conditions and the following disclaimer in the
	//       documentation and/or other materials provided with the distribution.
	//     * Neither the name of the u6k nor the
	//       names of its contributors may be used to endorse or promote products
	//       derived from this software without specific prior written permission.
	// 
	// THIS SOFTWARE IS PROVIDED BY u6k.yu1@gmail.com ``AS IS'' AND ANY
	// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
	// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
	// DISCLAIMED. IN NO EVENT SHALL u6k.yu1@gmail.com BE LIABLE FOR ANY
	// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
	// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	
	require_once(dirname(__FILE__) . "/common/common.php");
	require_once(dirname(__FILE__) . "/logic/Hirameki_ArticleLogic.php");
	
	if (isset($_GET["id"])) {
		if (!is_numeric($_GET["id"])) {
			throw new ArgumentException("id引数(GET)が数値ではありません。");
		}
		
		$article = Hirameki_ArticleLogic::findByID(intval($_GET["id"]));
	} else if (isset($_POST["id"])) {
		if (!is_numeric($_POST["id"])) {
			throw new ArgumentException("id引数(POST)が数値ではありません。");
		}
		
		$message = array();
		
		if (empty($_POST["content"])) {
			$message[] = "内容を入力してください。";
		}
		
		if (count($message) === 0) {
			Hirameki_ArticleLogic::update(intval($_POST["id"]), 1, $_POST["title"], $_POST["content"], $_POST["tag"]);
			
			$id = $_POST["id"];
			
			require_once("article_update_complete.php");
			exit;
		} else {
			$article = array(
				"id" => $_POST["id"],
				"title" => $_POST["title"],
				"content" => $_POST["content"],
				"tag" => $_POST["tag"]
			);
		}
	} else {
		throw new HiramekiException("HTTPリクエストが不正です。");
	}
	
	Hirameki_HtmlUtil::headerContentType();
	
	$page_title = "記事の更新";
	require_once("page_header.php");
?>
<?php
	if (isset($message)) {
?>
		<div id="message">
			<ul>
<?php
	foreach ($message as $m) {
?>
				<li><?php Hirameki_HtmlUtil::printStr($m); ?></li>
<?php
	}
?>
			</ul>
		</div>
<?php
	}
?>
		<div id="content">
			<form action="article_update.php" method="post">
				<div id="command"><input type="submit" value="更新"></input> <a href="article_detail.php?id=<?php Hirameki_HtmlUtil::printInt($article["id"]); ?>">戻る</a></div>
				<table id="article_detail" border="1">
					<tr>
						<th>ID</th>
						<td><?php Hirameki_HtmlUtil::printInt($article["id"]); ?><input type="hidden" name="id" value="<?php Hirameki_HtmlUtil::printInt($article["id"]); ?>"></input></td>
					</tr>
					<tr>
						<th>件名</th>
						<td><input type="text" name="title" value="<?php print($article["title"]); ?>"></input></td>
					</tr>
					<tr>
						<th>内容</th>
						<td><textarea name="content" rows="5" cols="60"><?php print($article["content"]); ?></textarea></td>
					</tr>
					<tr>
						<th>タグ</th>
						<td><input tyoe="text" name="tag" value="<?php print($article["tag"]); ?>"></input></td>
					</tr>
				</table>
				<div id="command"><input type="submit" value="更新"></input> <a href="article_detail.php?id=<?php Hirameki_HtmlUtil::printInt($article["id"]); ?>">戻る</a></div>
			</form>
		</div>
<?php
	require_once("page_footer.php");
?>
