<?php
	// Copyright (c) 2008, u6k.yu1@gmail.com
	// All rights reserved.
	// 
	// Redistribution and use in source and binary forms, with or without
	// modification, are permitted provided that the following conditions are met:
	//     * Redistributions of source code must retain the above copyright
	//       notice, this list of conditions and the following disclaimer.
	//     * Redistributions in binary form must reproduce the above copyright
	//       notice, this list of conditions and the following disclaimer in the
	//       documentation and/or other materials provided with the distribution.
	//     * Neither the name of the u6k nor the
	//       names of its contributors may be used to endorse or promote products
	//       derived from this software without specific prior written permission.
	// 
	// THIS SOFTWARE IS PROVIDED BY u6k.yu1@gmail.com ``AS IS'' AND ANY
	// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
	// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
	// DISCLAIMED. IN NO EVENT SHALL u6k.yu1@gmail.com BE LIABLE FOR ANY
	// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
	// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	
	require_once(dirname(__FILE__) . "/common/common.php");
	require_once(dirname(__FILE__) . "/logic/Hirameki_ArticleLogic.php");
	
	if (!is_numeric($_GET["id"])) {
		throw new ArgumentException("id引数(GET)が数値ではありません。");
	}
	
	$article = Hirameki_ArticleLogic::findByID(intval($_GET["id"]));
	
	Hirameki_HtmlUtil::headerContentType();
	
	$page_title = "記事の詳細";
	require_once("page_header.php");
?>
		<div id="content">
			<div id="command"><a href="article_update.php?id=<?php Hirameki_HtmlUtil::printInt($article["id"]); ?>">更新</a> <a href="article_delete.php?id=<?php Hirameki_HtmlUtil::printInt($article["id"]); ?>">削除</a></div>
			<table id="article_detail" border="1">
				<tr>
					<th>ID</th>
					<td><?php Hirameki_HtmlUtil::printInt($article["id"]); ?></td>
				</tr>
				<tr>
					<th>件名</th>
					<td><?php Hirameki_HtmlUtil::printStr($article["title"]); ?></td>
				</tr>
				<tr>
					<th>登録日時</th>
					<td><?php Hirameki_HtmlUtil::printTime($article["create_time"]); ?></td>
				</tr>
				<tr>
					<th>登録者</th>
					<td><?php Hirameki_HtmlUtil::printStr($article["create_account_real_name"]); ?></td>
				</tr>
				<tr>
					<th>更新日時</th>
					<td><?php Hirameki_HtmlUtil::printTime($article["update_time"]); ?></td>
				</tr>
				<tr>
					<th>更新者</th>
					<td><?php Hirameki_HtmlUtil::printStr($article["update_account_real_name"]); ?></td>
				</tr>
				<tr>
					<th>内容</th>
					<td><?php Hirameki_HtmlUtil::printStr($article["content"]); ?></td>
				</tr>
				<tr>
					<th>タグ</th>
					<td><?php Hirameki_HtmlUtil::printStr($article["tag"]); ?></td>
				</tr>
			</table>
			<div id="command"><a href="article_update.php?id=<?php Hirameki_HtmlUtil::printInt($article["id"]); ?>">更新</a> <a href="article_delete.php?id=<?php Hirameki_HtmlUtil::printInt($article["id"]); ?>">削除</a></div>
		</div>
<?php
	require_once("page_footer.php");
?>
