/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.ejb.session.MonitorSyslogNGController;
import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitor;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitorSyslogng
extends ImportMonitor {
    private static Log log = LogFactory.getLog(ImportMonitorSyslogng.class);
    private ArrayList<LogFilterInfo> monitorList = null;
    private ArrayList<ArrayList<String>> monitorInfos = null;

    public void importSyslogng() {
        log.info((Object)Messages.getMsg("Syslogng.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/SYSLOGNG.csv");
        this.monitorList = this.getMonitorList();
        ArrayList<LogFilterInfo> arrayList = new ArrayList<LogFilterInfo>();
        for (ArrayList<String> arrayList2 : this.monitorInfos) {
            MonitorInfo monitorInfo = this.createMonitorInfo(arrayList2);
            LogFilterInfo logFilterInfo = this.checkMonitorList(monitorInfo.getMonitorId(), this.monitorList);
            if (logFilterInfo instanceof LogFilterInfo) {
                monitorInfo.setRegDate(logFilterInfo.getRegDate());
                monitorInfo.setRegUser(logFilterInfo.getRegUser());
            }
            Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
            log.info((Object)Messages.getMsg("MonitorID", objectArray));
            arrayList.add((LogFilterInfo)monitorInfo);
        }
        this.registerMonitorInfo(arrayList);
        log.info((Object)Messages.getMsg("Syslogng.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    @Override
    public MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        LogFilterInfo logFilterInfo = new LogFilterInfo();
        this.createMonitorBase(arrayList, (MonitorInfo)logFilterInfo);
        this.createMonitorRule(arrayList.subList(3, 5), (MonitorInfo)logFilterInfo);
        this.createMonitorCheck(arrayList.subList(5, 7), (MonitorInfo)logFilterInfo);
        this.createMonitorNotify(arrayList.subList(7, 13), (MonitorInfo)logFilterInfo);
        this.createMonitorApplication(arrayList.subList(13, 14), (MonitorInfo)logFilterInfo);
        this.createMonitorMessages(arrayList.subList(14, 17), (MonitorInfo)logFilterInfo);
        this.createMonitorVaild(arrayList.subList(17, 18), (MonitorInfo)logFilterInfo);
        return logFilterInfo;
    }

    @Override
    protected void createMonitorBase(List<String> list, MonitorInfo monitorInfo) {
        Object[] objectArray;
        LogFilterInfo logFilterInfo = (LogFilterInfo)monitorInfo;
        logFilterInfo.setOrderNo(Integer.parseInt(list.get(0)));
        String string = CheckString.checkLength(list.get(1), 64);
        if (!string.equals(list.get(1))) {
            objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"monitor.id"), "64"};
            log.error((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
            System.exit(20);
        }
        logFilterInfo.setMonitorId(string);
        objectArray = CheckString.checkLength(list.get(2), 256);
        if (!objectArray.equals(list.get(2))) {
            Object[] objectArray2 = new String[]{com.clustercontrol.util.Messages.getString((String)"description"), "256"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray2));
        }
        logFilterInfo.setDescription((String)objectArray);
    }

    @Override
    protected void createMonitorRule(List<String> list, MonitorInfo monitorInfo) {
        if (list.get(0) != null && !"".equals(list.get(0))) {
            monitorInfo.setCalendarId(list.get(0));
        } else {
            monitorInfo.setCalendarId(null);
        }
        monitorInfo.setFacilityId(list.get(1));
    }

    @Override
    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        LogFilterInfo logFilterInfo = (LogFilterInfo)monitorInfo;
        String string = CheckString.checkLength(list.get(0), 1024);
        if (!string.equals(list.get(0))) {
            Object[] objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"pattern.matching.expression"), "1024"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
        }
        logFilterInfo.setPattern(string);
        logFilterInfo.setProcessType(ProcessConstant.stringToType((String)list.get(1)));
    }

    protected void createMonitorMessages(List<String> list, MonitorInfo monitorInfo) {
        Object[] objectArray;
        LogFilterInfo logFilterInfo = (LogFilterInfo)monitorInfo;
        logFilterInfo.setPriority(PriorityConstant.stringToType((String)list.get(0)));
        String string = CheckString.checkLength(list.get(1), 64);
        if (!string.equals(list.get(1))) {
            objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"message.id"), "64"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
        }
        logFilterInfo.setMessageId(string);
        objectArray = CheckString.checkLength(list.get(2), 256);
        if (!objectArray.equals(list.get(2))) {
            Object[] objectArray2 = new String[]{com.clustercontrol.util.Messages.getString((String)"message"), "256"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray2));
        }
        logFilterInfo.setMessage((String)objectArray);
    }

    protected void registerMonitorInfo(ArrayList<LogFilterInfo> arrayList) {
        MonitorSyslogNGController monitorSyslogNGController = EjbConnectionManager.getConnectionManager().getMonitorSyslogNGController();
        try {
            monitorSyslogNGController.createMonitorRuleList(arrayList);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected LogFilterInfo checkMonitorList(String string, ArrayList<LogFilterInfo> arrayList) {
        if (arrayList instanceof ArrayList) {
            for (LogFilterInfo logFilterInfo : arrayList) {
                if (logFilterInfo.getMonitorId().compareTo(string) != 0) continue;
                return logFilterInfo;
            }
        }
        return null;
    }

    protected ArrayList<LogFilterInfo> getMonitorList() {
        MonitorSyslogNGController monitorSyslogNGController = EjbConnectionManager.getConnectionManager().getMonitorSyslogNGController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorSyslogNGController.getFilterInfoList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

