/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.job;

import java.util.ArrayList;
import java.util.Locale;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.LoginManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobManagementUserInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.ejb.session.JobController;

/**
 * ジョブ管理情報を削除するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class DeleteJob {

	// ログ出力
	private static Log log = LogFactory.getLog(DeleteJob.class);

	/**
	 * ジョブ管理情報を削除する。<br>
	 */
	public void delete() {
		log.info(Messages.getMsg("Job.Start", new String[]{Messages.getMsg("ImportTool.Delete")}));

		//ジョブツリー取得
		JobTreeItem jobTree = getJobTree();

		log.info(Messages.getMsg("Job.Register.Start"));

		//ジョブ削除
		deleteJob(jobTree);

		log.info(Messages.getMsg("Job.Register.End"));

		log.info(Messages.getMsg("Job.End", new String[]{Messages.getMsg("ImportTool.Delete")}));
	}

	/**
	 * パラメータ情報取得（再帰呼び出し）
	 * 
	 * @param treeItem ジョブツリー
	 */
	public void deleteJob(JobTreeItem treeItem) {

		//子ツリーを取得する
		if (treeItem.getData() instanceof JobInfo){
			JobInfo info = treeItem.getData();
			if(info.getId() != null && 
					info.getId().compareTo("") != 0 && 
					info.getType() == JobConstant.TYPE_JOBUNIT){
				if(isReferable(info)){
					Object[] args = {info.getId()};
					log.info(Messages.getMsg("JobID", args));
					deleteJobunit(info.getJobunitId());
				}
			}
		}

		JobTreeItem[] childrenTreeItem = treeItem.getChildrenArray();
		for (JobTreeItem childTreeItem : childrenTreeItem) {
			deleteJob(childTreeItem);
		}
	}

	/**
	 * ジョブの参照権限の有無を確認する。<br>
	 * 
	 * @param info ジョブ
	 * @return 有無
	 */
	protected boolean isReferable(JobInfo info) {
		boolean isReferableJobunit = false;
		
		ArrayList<JobManagementUserInfo> userInfo = info.getManagementUser();
		if (userInfo == null || userInfo.size() == 0) {
			isReferableJobunit = true;
		} else {
			for (JobManagementUserInfo i : userInfo) {
				String loginUser = LoginManager.getContextManager().getUserId();
				if (loginUser.equals(i.getUserId())) {
					isReferableJobunit = true;
					break;
				}
			}
		}
		return isReferableJobunit;
	}

	/**
	 * ジョブツリーを削除する。<br>
	 * 
	 * @param jobUnitId ジョブユニットID
	 */
	protected void deleteJobunit(String jobUnitId) {
		JobController job = 
			EjbConnectionManager.getConnectionManager().getJobController();

		try {
			job.deleteJobunit(jobUnitId);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * ジョブツリーを取得する。<br>
	 * 
	 * @return ジョブツリー
	 */
	protected JobTreeItem getJobTree() {

		JobController job = EjbConnectionManager.getConnectionManager().getJobController();

		JobTreeItem jobTree = null;
		try {
			jobTree = job.getJobTree(false, Locale.getDefault());
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return jobTree;
	}
}