/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.export.conf.monitor;

import java.util.ArrayList;
import java.util.List;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.sql.bean.JdbcDriverInfo;
import com.clustercontrol.sql.ejb.session.MonitorSqlController;

/**
 * JDBCドライバリソース取得クラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class JdbcDriverUtil {
	// ログ出力
	private static Log log = LogFactory.getLog(JdbcDriverUtil.class);

	private JdbcDriverUtil() {

	}

	/**
	 * JDBCドライバ名、クラス名を取得
	 * 
	 * @return JDBCドライバ一覧
	 */
	public static List<List<String>> getJdbcDriver() {
		List<List<String>> list = new ArrayList<List<String>>();

		MonitorSqlController sql = EjbConnectionManager.getConnectionManager().getMonitorSqlController();

		try {
			ArrayList<JdbcDriverInfo> driverList = sql.getJdbcDriverList();
			for (JdbcDriverInfo driver : driverList) {
				ArrayList<String> a = new ArrayList<String>();
				a.add(driver.getJdbcDriverName());
				a.add(driver.getJdbcDriverClass());
				list.add(a);
			}
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}

		return list;
	}
}