/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.check.conf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import com.clustercontrol.notify.bean.NotifyRelationInfo;

/**
 * 監視情報を取得するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CheckMonitorString extends CheckMonitor {

	/**
	 * 判定条件の通知数を取得する。<br>
	 * 
	 * @param monitorInfo 監視情報
	 * @return 通知数
	 */
	@SuppressWarnings("unchecked")
	public int getJudgementNotifyCount(MonitorInfo monitorInfo) {
		int max = 0;

		ArrayList list = monitorInfo.getJudgementInfo();
		if(list instanceof ArrayList){
			Iterator itr = list.iterator();
			while(itr.hasNext()){
				MonitorStringValueInfo line = (MonitorStringValueInfo)itr.next();

				int count = getJudgementNotifyCount(line);
				if(count > max)
					max = count;
			}
		}

		return max;
	}

	/**
	 * 判定条件の通知数を取得する。<br>
	 * 
	 * @param monitorInfo 監視情報
	 * @return 通知数
	 */
	protected int getJudgementNotifyCount(MonitorStringValueInfo monitorInfo) {
		int count = 0;

		if(monitorInfo.getNotifyId() != null){
			Collection<NotifyRelationInfo> notify = monitorInfo.getNotifyId();

			count = notify.size();
		}

		return count;
	}
}