/*
 
Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.export.conf.monitor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;

import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.hinemosagent.bean.MonitorAgentInfo;
import com.clustercontrol.hinemosagent.ejb.session.MonitorAgentController;
import com.clustercontrol.monitor.run.bean.MonitorInfo;

/**
 * エージェント監視情報を取得するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ExportMonitorAgent extends ExportMonitorTruth {

	// ログ出力
	private static Log log = LogFactory.getLog(ExportMonitorAgent.class);
	
	/**
     * エージェント監視情報をExportする。<br>
     */
    public void exportAgent() {
    	log.info(Messages.getMsg("Agent.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
    	
    	//CSV出力配列を用意
    	ArrayList<ArrayList<String>> csvOutput = new ArrayList<ArrayList<String>>();
    	
    	//監視項目リスト取得
    	ArrayList idList = getAgentList();
    	
    	if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();
				
				Object[] args = {(String)line.get(0)};
				log.info(Messages.getMsg("MonitorID", args));
				
				MonitorInfo info = getAgent((String)line.get(0));
				csvOutput.add(createCsvFormat(info));
			}
			
			//監視項目IDでソート
			Collections.sort(csvOutput, new StringListComparator(0));
    	}
    	
		String timestamp = "";
		if(Config.getConfig("file.timestamp").equalsIgnoreCase("on")){
			SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");
			timestamp = "_" + format.format(new Date());
		}
		WriteCsvFile.writeCsvFile(
				Config.getConfig("Export.Dir") + "/AGENT" + timestamp + ".csv", 
				csvOutput);
		
    	log.info(Messages.getMsg("Agent.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }
    
    /**
	 * エージェント監視情報をExportする。<br>
	 * 
	 * @param monitorInfo エージェント監視情報
	 * @return CSVフォーマット文字列
	 */
    @Override
	public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
		ArrayList<String> csvFormat = new ArrayList<String>();
		
		MonitorAgentInfo agentInfo = (MonitorAgentInfo)monitorInfo.getCheckInfo();
        if(agentInfo == null){
        	agentInfo = new MonitorAgentInfo();
        }
        //ジョブエージェント
        if (agentInfo.getCheckJobAgent() != null)
        	csvFormat.add(YesNoConstant.typeToString(agentInfo.getCheckJobAgent().intValue()));
        else
        	csvFormat.add("");
        //ログ転送エージェント
        if (agentInfo.getCheckLogAgent() != null)
        	csvFormat.add(YesNoConstant.typeToString(agentInfo.getCheckLogAgent().intValue()));
        else
        	csvFormat.add("");

		return csvFormat;
	}

    /**
     * エージェント監視情報を取得する。<br>
     * 
     * @param monitorId 取得対象の監視項目ID
     * @return エージェント監視情報
     */
    protected MonitorInfo getAgent(String monitorId) {

        MonitorAgentController agent = EjbConnectionManager.getConnectionManager().getMonitorAgentController();

        MonitorInfo info = null;
        try {
        	info = agent.getAgentInfo(monitorId);
        } catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
        }
        return info;
    }
    
    /**
     * 監視項目リストを取得する。<br>
     * 
     * @return 監視項目一覧
     */
    protected ArrayList getAgentList() {

    	MonitorAgentController agent = EjbConnectionManager.getConnectionManager().getMonitorAgentController();

    	ArrayList records = null;
    	try {
    		records = agent.getAgentList();
        } catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
        }
        return records;
    }
}