/*
 
Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.util;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * CSVファイル出力クラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class WriteCsvFile {

	// ログ出力
	private static Log log = LogFactory.getLog(WriteCsvFile.class);
	
	/**
	 * CSVファイルに出力する。<br>
	 * 
	 * @param filePath
	 *            CSVファイルのファイルパス
	 * @param csvOutput
	 *            格納配列
	 */
	public static void writeCsvFile(
			String filePath, 
			ArrayList<ArrayList<String>> csvOutput) {

		// ファイル書き込み用変数
		FileOutputStream fos = null;
		BufferedOutputStream bos = null;
		FileChannel channel = null;
		StringBuffer line = new StringBuffer();

		// CSVファイルへの出力
		try {
			// 出力ファイルを開く
			fos = new FileOutputStream(filePath, true);

			// ファイルの排他制御（排他ロックを取得）
			channel = fos.getChannel();
			if (channel.tryLock() == null) {
				// ロックに失敗した場合
				log.error(Messages.getMsg("JMXTool.LockFileFailed"));
				System.exit(51);
			}
			
			bos = new BufferedOutputStream(fos);

			// CSVの出力
			for (ArrayList<String> csvLine : csvOutput) {
				line.delete(0, line.length());
				// 出力項目ごとに出力
				int index = 0;
				for (String column : csvLine) {
					if(index > 0)
						line.append("\t");
					line.append(column);
					index++;
				}
				line.append("\n");
				bos.write(line.toString().getBytes());
			}

		} catch (Exception e) {
			// ファイルの書き込み処理に失敗した場合
			log.error(Messages.getMsg("JMXTool.WriteFileFailed"), e);
			System.exit(51);
		} finally {
			try {
				// 出力ファイルに書き出し内容を反映して閉じる
				if (bos != null) {
					bos.flush();
					bos.close();
				}
			} catch (IOException e) {
				// ファイルの書き込み処理に失敗した場合
				log.error(Messages.getMsg("JMXTool.WriteFileFailed"), e);
				System.exit(51);
			}
		}

		return;
	}

}
