/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.monitor.bean.PerfCheckInfo;
import com.clustercontrol.performance.monitor.ejb.session.MonitorPerfController;
import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitorNumeric;
import jp.co.intellilink.hinemos.importtool.conf.performance.CollectorItemCodeFactory;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitorPerformance
extends ImportMonitorNumeric {
    private static Log log = LogFactory.getLog(ImportMonitorPerformance.class);
    private ArrayList monitorList = null;
    private ArrayList<ArrayList<String>> monitorInfos = null;

    public void importPerformance() {
        log.info((Object)Messages.getMsg("Resource.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/RESOURCE.csv");
        this.monitorList = this.getMonitorList();
        for (ArrayList<String> arrayList : this.monitorInfos) {
            MonitorInfo monitorInfo = this.createMonitorInfo(arrayList);
            this.registerMonitorInfo(monitorInfo);
        }
        log.info((Object)Messages.getMsg("Resource.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    @Override
    protected MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        MonitorInfo monitorInfo = new MonitorInfo();
        this.createMonitorBase(arrayList, monitorInfo);
        this.createMonitorRule(arrayList.subList(3, 5), monitorInfo);
        this.createMonitorCheck(arrayList.subList(5, 6), monitorInfo);
        this.createMonitorBlock(arrayList.subList(6, 7), monitorInfo);
        this.createMonitorJudgement(arrayList.subList(7, 12), monitorInfo);
        this.createMonitorNotify(arrayList.subList(12, 18), monitorInfo);
        this.createMonitorApplication(arrayList.subList(18, 19), monitorInfo);
        this.createMonitorVaild(arrayList.subList(19, 20), monitorInfo);
        return monitorInfo;
    }

    @Override
    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        PerfCheckInfo perfCheckInfo = new PerfCheckInfo();
        List<CollectorItemInfo> list2 = CollectorItemCodeFactory.getAvailableCollectorItemList(monitorInfo.getFacilityId());
        for (CollectorItemInfo collectorItemInfo : list2) {
            String string = CollectorItemCodeFactory.getFullItemName(collectorItemInfo);
            if (!string.equals(list.get(0))) continue;
            perfCheckInfo.setItemCode(collectorItemInfo.getItemCode());
            perfCheckInfo.setDisplayName(collectorItemInfo.getDisplayName());
            break;
        }
        monitorInfo.setPerfCheckInfo(perfCheckInfo);
        monitorInfo.setMonitorType(1);
        super.createMonitorCheck(list, monitorInfo);
    }

    protected void registerMonitorInfo(MonitorInfo monitorInfo) {
        MonitorPerfController monitorPerfController = EjbConnectionManager.getConnectionManager().getMonitorPerfController();
        try {
            MonitorInfo monitorInfo2 = this.checkMonitorList(monitorInfo.getMonitorId(), this.monitorList);
            if (monitorInfo2 instanceof MonitorInfo) {
                monitorInfo.setRegDate(monitorInfo2.getRegDate());
                monitorInfo.setRegUser(monitorInfo2.getRegUser());
                MonitorInfo monitorInfo3 = this.getPerformance(monitorInfo.getMonitorId());
                String string = monitorInfo3.getPerfCheckInfo().getCollectorId();
                monitorInfo.getPerfCheckInfo().setCollectorId(string);
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                monitorPerfController.modifyPerformance(monitorInfo);
            } else {
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                monitorPerfController.addPerformance(monitorInfo);
            }
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected MonitorInfo getPerformance(String string) {
        MonitorPerfController monitorPerfController = EjbConnectionManager.getConnectionManager().getMonitorPerfController();
        MonitorInfo monitorInfo = null;
        try {
            monitorInfo = monitorPerfController.getPerformance(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return monitorInfo;
    }

    protected ArrayList getMonitorList() {
        MonitorPerfController monitorPerfController = EjbConnectionManager.getConnectionManager().getMonitorPerfController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorPerfController.getPerformanceList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

