/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.monitor;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.hinemosagent.bean.MonitorAgentInfo;
import com.clustercontrol.hinemosagent.ejb.session.MonitorAgentController;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorTruth;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMonitorAgent
extends ExportMonitorTruth {
    private static Log log = LogFactory.getLog(ExportMonitorAgent.class);

    public void exportAgent() {
        log.info((Object)Messages.getMsg("Agent.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getAgentList();
        if (arrayList2 instanceof ArrayList) {
            for (Cloneable cloneable : arrayList2) {
                Object[] objectArray = new Object[]{(String)((ArrayList)cloneable).get(0)};
                log.info((Object)Messages.getMsg("MonitorID", objectArray));
                MonitorInfo monitorInfo = this.getAgent((String)((ArrayList)cloneable).get(0));
                arrayList.add(this.createCsvFormat(monitorInfo));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        Object object = "";
        if (Config.getConfig("file.timestamp").equalsIgnoreCase("on")) {
            Cloneable cloneable;
            cloneable = new SimpleDateFormat("yyyyMMdd_HHmmss");
            object = "_" + ((DateFormat)cloneable).format(new Date());
        }
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/AGENT" + (String)object + ".csv", arrayList);
        log.info((Object)Messages.getMsg("Agent.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    @Override
    public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        MonitorAgentInfo monitorAgentInfo = (MonitorAgentInfo)monitorInfo.getCheckInfo();
        if (monitorAgentInfo == null) {
            monitorAgentInfo = new MonitorAgentInfo();
        }
        if (monitorAgentInfo.getCheckJobAgent() != null) {
            arrayList.add(YesNoConstant.typeToString((int)monitorAgentInfo.getCheckJobAgent()));
        } else {
            arrayList.add("");
        }
        if (monitorAgentInfo.getCheckLogAgent() != null) {
            arrayList.add(YesNoConstant.typeToString((int)monitorAgentInfo.getCheckLogAgent()));
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    protected MonitorInfo getAgent(String string) {
        MonitorAgentController monitorAgentController = EjbConnectionManager.getConnectionManager().getMonitorAgentController();
        MonitorInfo monitorInfo = null;
        try {
            monitorInfo = monitorAgentController.getAgentInfo(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return monitorInfo;
    }

    protected ArrayList getAgentList() {
        MonitorAgentController monitorAgentController = EjbConnectionManager.getConnectionManager().getMonitorAgentController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorAgentController.getAgentList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

