/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpAccess;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.snmp.SnmpTextualConvention;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class SnmpVariation {
    private MibValue value;
    private MibType syntax;
    private MibType writeSyntax;
    private SnmpAccess access;
    private ArrayList requiredCells;
    private MibValue defaultValue;
    private String description;

    public SnmpVariation(MibValue value, MibType syntax, MibType writeSyntax, SnmpAccess access, ArrayList requiredCells, MibValue defaultValue, String description) {
        this.value = value;
        this.syntax = syntax;
        this.writeSyntax = writeSyntax;
        this.access = access;
        this.requiredCells = requiredCells;
        this.defaultValue = defaultValue;
        this.description = description;
    }

    void initialize(MibLoaderLog log) throws MibException {
        ArrayList<MibValue> list = new ArrayList<MibValue>();
        MibType type = null;
        this.value = this.value.initialize(log, null);
        if (this.getBaseSymbol() != null) {
            type = this.getBaseSymbol().getType();
            if (type instanceof SnmpTextualConvention) {
                type = ((SnmpTextualConvention)type).getSyntax();
            }
            if (type instanceof SnmpObjectType) {
                type = ((SnmpObjectType)type).getSyntax();
            }
        }
        if (this.syntax != null) {
            this.syntax = this.syntax.initialize(null, log);
        }
        if (this.writeSyntax != null) {
            this.writeSyntax = this.writeSyntax.initialize(null, log);
        }
        for (int i = 0; i < this.requiredCells.size(); ++i) {
            list.add(((MibValue)this.requiredCells.get(i)).initialize(log, type));
        }
        this.requiredCells = list;
        if (this.defaultValue != null) {
            this.defaultValue = this.defaultValue.initialize(log, type);
        }
    }

    public MibValueSymbol getBaseSymbol() {
        if (this.value instanceof ObjectIdentifierValue) {
            return ((ObjectIdentifierValue)this.value).getSymbol();
        }
        return null;
    }

    public MibValue getValue() {
        return this.value;
    }

    public MibType getSyntax() {
        return this.syntax;
    }

    public MibType getWriteSyntax() {
        return this.writeSyntax;
    }

    public SnmpAccess getAccess() {
        return this.access;
    }

    public ArrayList getRequiredCells() {
        return this.requiredCells;
    }

    public MibValue getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.value);
        if (this.syntax != null) {
            buffer.append("\n      Syntax: ");
            buffer.append(this.syntax);
        }
        if (this.writeSyntax != null) {
            buffer.append("\n      Write-Syntax: ");
            buffer.append(this.writeSyntax);
        }
        if (this.access != null) {
            buffer.append("\n      Access: ");
            buffer.append(this.access);
        }
        if (this.requiredCells.size() > 0) {
            buffer.append("\n      Creation-Requires: ");
            buffer.append(this.requiredCells);
        }
        if (this.defaultValue != null) {
            buffer.append("\n      Default Value: ");
            buffer.append(this.defaultValue);
        }
        buffer.append("\n      Description: ");
        buffer.append(this.description);
        return buffer.toString();
    }
}

