/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.ElementType;

public class ChoiceType
extends MibType {
    private ArrayList elements;

    public ChoiceType(ArrayList elements) {
        this(true, elements);
    }

    private ChoiceType(boolean primitive, ArrayList elements) {
        super("CHOICE", primitive);
        this.elements = elements;
    }

    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        for (int i = 0; i < this.elements.size(); ++i) {
            ElementType elem = (ElementType)this.elements.get(i);
            elem.initialize(symbol, log);
        }
        return this;
    }

    public MibType createReference() {
        ChoiceType type = new ChoiceType(false, this.elements);
        type.setTag(true, this.getTag());
        return type;
    }

    public boolean isCompatible(MibValue value) {
        for (int i = 0; i < this.elements.size(); ++i) {
            ElementType elem = (ElementType)this.elements.get(i);
            if (!elem.isCompatible(value)) continue;
            return true;
        }
        return false;
    }

    public ElementType[] getAllElements() {
        ElementType[] res = new ElementType[this.elements.size()];
        this.elements.toArray(res);
        return res;
    }

    public String toString() {
        return super.toString() + " " + this.elements.toString();
    }
}

