/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.job;

import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobManagementUserInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import java.util.ArrayList;
import java.util.Locale;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.LoginManager;
import jp.co.intellilink.hinemos.util.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteJob {
    private static Log log = LogFactory.getLog(DeleteJob.class);

    public void delete() {
        log.info((Object)Messages.getMsg("Job.Start", new String[]{Messages.getMsg("ImportTool.Delete")}));
        JobTreeItem jobTreeItem = this.getJobTree();
        log.info((Object)Messages.getMsg("Job.Register.Start"));
        this.deleteJob(jobTreeItem);
        log.info((Object)Messages.getMsg("Job.Register.End"));
        log.info((Object)Messages.getMsg("Job.End", new String[]{Messages.getMsg("ImportTool.Delete")}));
    }

    public void deleteJob(JobTreeItem jobTreeItem) {
        JobTreeItem[] jobTreeItemArray;
        if (jobTreeItem.getData() instanceof JobInfo && (jobTreeItemArray = jobTreeItem.getData()).getId() != null && jobTreeItemArray.getId().compareTo("") != 0 && jobTreeItemArray.getType() == 0 && this.isReferable((JobInfo)jobTreeItemArray)) {
            Object[] objectArray = new Object[]{jobTreeItemArray.getId()};
            log.info((Object)Messages.getMsg("JobID", objectArray));
            this.deleteJobunit(jobTreeItemArray.getJobunitId());
        }
        jobTreeItemArray = jobTreeItem.getChildrenArray();
        for (JobTreeItem jobTreeItem2 : jobTreeItemArray) {
            this.deleteJob(jobTreeItem2);
        }
    }

    protected boolean isReferable(JobInfo jobInfo) {
        boolean bl = false;
        ArrayList arrayList = jobInfo.getManagementUser();
        if (arrayList == null || arrayList.size() == 0) {
            bl = true;
        } else {
            for (JobManagementUserInfo jobManagementUserInfo : arrayList) {
                String string = LoginManager.getContextManager().getUserId();
                if (!string.equals(jobManagementUserInfo.getUserId())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    protected void deleteJobunit(String string) {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        try {
            jobController.deleteJobunit(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected JobTreeItem getJobTree() {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        JobTreeItem jobTreeItem = null;
        try {
            jobTreeItem = jobController.getJobTree(false, Locale.getDefault());
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return jobTreeItem;
    }
}

