/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.history;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.jobmanagement.bean.JobHistory;
import com.clustercontrol.jobmanagement.bean.JobHistoryFilter;
import com.clustercontrol.jobmanagement.bean.JobHistoryList;
import com.clustercontrol.jobmanagement.bean.JobNodeDetail;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportJob {
    private static Log log = LogFactory.getLog(ExportJob.class);

    public void export(Date date) {
        log.info((Object)Messages.getMsg("ExportTool.Job.Start"));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date2 = calendar.getTime();
        calendar.add(5, 1);
        calendar.add(14, -1);
        Date date3 = calendar.getTime();
        JobHistoryList jobHistoryList = this.getSessionList(date2, date3);
        if (jobHistoryList.getList() instanceof ArrayList) {
            for (JobHistory jobHistory : jobHistoryList.getList()) {
                Object[] objectArray = new Object[]{jobHistory.getSessionId()};
                log.info((Object)Messages.getMsg("SessionID", objectArray));
                CommonTableTreeItem commonTableTreeItem = this.getJobDetail(jobHistory.getSessionId());
                this.getJobDetailData(jobHistory, commonTableTreeItem, arrayList);
                this.getJobNodeData(jobHistory, commonTableTreeItem, arrayList2);
            }
        }
        Collections.sort(arrayList, new StringListComparator(4));
        Collections.sort(arrayList, new StringListComparator(3));
        arrayList.add(0, this.createDetailCsvHeader());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        WriteCsvFile.writeCsvFile(Config.getConfig("History.Dir") + "/JOB_" + simpleDateFormat.format(date2) + ".csv", arrayList);
        Collections.sort(arrayList2, new StringListComparator(3));
        Collections.sort(arrayList2, new StringListComparator(2));
        arrayList2.add(0, this.createNodeCsvHeader());
        WriteCsvFile.writeCsvFile(Config.getConfig("History.Dir") + "/JOB_NODE_" + simpleDateFormat.format(date2) + ".csv", arrayList2);
        log.info((Object)Messages.getMsg("ExportTool.Job.End"));
    }

    public ArrayList<String> createDetailCsvHeader() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"run.status"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"end.status"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"end.value"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"session.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"job.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"job.name"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"type"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"facility.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"scope"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"scheduled.start.time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"start.rerun.time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"end.suspend.time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"trigger.type"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"trigger.info"));
        return arrayList;
    }

    public void getJobDetailData(JobHistory jobHistory, CommonTableTreeItem commonTableTreeItem, ArrayList<ArrayList<String>> arrayList) {
        CommonTableTreeItem[] commonTableTreeItemArray;
        if (commonTableTreeItem.getData() instanceof ArrayList) {
            commonTableTreeItemArray = commonTableTreeItem.getData();
            String object = (String)commonTableTreeItemArray.get(4);
            Object[] objectArray = new Object[]{object};
            log.info((Object)Messages.getMsg("JobID", objectArray));
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(StatusConstant.typeToString((int)((Number)commonTableTreeItemArray.get(1)).intValue()));
            if (commonTableTreeItemArray.get(2) instanceof Number) {
                arrayList2.add(EndStatusConstant.typeToString((int)((Number)commonTableTreeItemArray.get(2)).intValue()));
            } else {
                arrayList2.add("");
            }
            if (commonTableTreeItemArray.get(3) instanceof Number) {
                arrayList2.add(((Number)commonTableTreeItemArray.get(3)).toString());
            } else {
                arrayList2.add("");
            }
            arrayList2.add(jobHistory.getSessionId());
            arrayList2.add((String)commonTableTreeItemArray.get(4));
            arrayList2.add((String)commonTableTreeItemArray.get(5));
            arrayList2.add(JobConstant.typeToString((int)((Number)commonTableTreeItemArray.get(7)).intValue()));
            if (commonTableTreeItemArray.get(8) instanceof String) {
                arrayList2.add((String)commonTableTreeItemArray.get(8));
            } else {
                arrayList2.add("");
            }
            if (commonTableTreeItemArray.get(9) instanceof String) {
                arrayList2.add((String)commonTableTreeItemArray.get(9));
            } else {
                arrayList2.add("");
            }
            if (commonTableTreeItem.getParent().getData() == null) {
                arrayList2.add(DateFormat.getDateTimeInstance().format(jobHistory.getScheduleDate()));
            } else {
                arrayList2.add("");
            }
            if (commonTableTreeItemArray.get(10) != null) {
                Class<?> clazz = commonTableTreeItemArray.get(10).getClass();
                if (clazz == Date.class) {
                    arrayList2.add(new SimpleDateFormat("HH:mm").format((Date)commonTableTreeItemArray.get(10)));
                } else if (clazz == String.class) {
                    arrayList2.add((String)commonTableTreeItemArray.get(10));
                } else if (clazz.getSuperclass() == Number.class) {
                    arrayList2.add(((Number)commonTableTreeItemArray.get(10)).toString());
                } else {
                    arrayList2.add("");
                }
            } else {
                arrayList2.add("");
            }
            if (commonTableTreeItemArray.get(11) instanceof Date) {
                arrayList2.add(DateFormat.getDateTimeInstance().format((Date)commonTableTreeItemArray.get(11)));
            } else {
                arrayList2.add("");
            }
            if (commonTableTreeItemArray.get(12) instanceof Date) {
                arrayList2.add(DateFormat.getDateTimeInstance().format((Date)commonTableTreeItemArray.get(12)));
            } else {
                arrayList2.add("");
            }
            if (commonTableTreeItem.getParent().getData() == null) {
                arrayList2.add(jobHistory.getJobTriggerType());
                arrayList2.add(jobHistory.getTriggerInfo());
            } else {
                arrayList2.add("");
                arrayList2.add("");
            }
            arrayList.add(arrayList2);
        }
        for (CommonTableTreeItem commonTableTreeItem2 : commonTableTreeItemArray = commonTableTreeItem.getChildren()) {
            this.getJobDetailData(jobHistory, commonTableTreeItem2, arrayList);
        }
    }

    protected JobHistoryList getSessionList(Date date, Date date2) {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        JobHistoryList jobHistoryList = null;
        try {
            JobHistoryFilter jobHistoryFilter = new JobHistoryFilter();
            if (date instanceof Date) {
                jobHistoryFilter.setStartFromDate(date);
            }
            if (date2 instanceof Date) {
                jobHistoryFilter.setStartToDate(date2);
            }
            int n = Integer.parseInt(Config.getConfig("history.job.max.list"));
            jobHistoryList = jobController.getHistoryList(jobHistoryFilter, n);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return jobHistoryList;
    }

    protected CommonTableTreeItem getJobDetail(String string) {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        CommonTableTreeItem commonTableTreeItem = null;
        try {
            commonTableTreeItem = jobController.getDetailList(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return commonTableTreeItem;
    }

    protected ArrayList getNodeList(String string, String string2, String string3) {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        ArrayList arrayList = null;
        try {
            arrayList = jobController.getNodeDetailList(string, string2, string3, Locale.getDefault());
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }

    public void getJobNodeData(JobHistory jobHistory, CommonTableTreeItem commonTableTreeItem, ArrayList<ArrayList<String>> arrayList) {
        CommonTableTreeItem[] commonTableTreeItemArray;
        if (commonTableTreeItem.getData() instanceof ArrayList && ((Number)(commonTableTreeItemArray = commonTableTreeItem.getData()).get(7)).intValue() == 2) {
            String object = jobHistory.getSessionId();
            String string = jobHistory.getJobunitId();
            String string2 = (String)commonTableTreeItemArray.get(4);
            Object object2 = (String)commonTableTreeItemArray.get(5);
            ArrayList arrayList2 = this.getNodeList(object, string, string2);
            if (arrayList2 instanceof ArrayList) {
                for (JobNodeDetail jobNodeDetail : arrayList2) {
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    arrayList3.add(StatusConstant.typeToString((int)jobNodeDetail.getStatus()));
                    if (jobNodeDetail.getEndValue() instanceof Integer) {
                        arrayList3.add(jobNodeDetail.getEndValue().toString());
                    } else {
                        arrayList3.add("");
                    }
                    arrayList3.add(object);
                    arrayList3.add(string2);
                    arrayList3.add((String)object2);
                    if (jobNodeDetail.getFacilityId() instanceof String) {
                        arrayList3.add(jobNodeDetail.getFacilityId());
                    } else {
                        arrayList3.add("");
                    }
                    if (jobNodeDetail.getNodeName() instanceof String) {
                        arrayList3.add(jobNodeDetail.getNodeName());
                    } else {
                        arrayList3.add("");
                    }
                    if (jobNodeDetail.getStartDate() instanceof Date) {
                        arrayList3.add(DateFormat.getDateTimeInstance().format(jobNodeDetail.getStartDate()));
                    } else {
                        arrayList3.add("");
                    }
                    if (jobNodeDetail.getEndDate() instanceof Date) {
                        arrayList3.add(DateFormat.getDateTimeInstance().format(jobNodeDetail.getEndDate()));
                    } else {
                        arrayList3.add("");
                    }
                    if (jobNodeDetail.getMessage() instanceof String) {
                        arrayList3.add(CheckString.checkReturn(jobNodeDetail.getMessage()));
                    } else {
                        arrayList3.add("");
                    }
                    arrayList.add(arrayList3);
                }
            }
        }
        for (Object object2 : commonTableTreeItemArray = commonTableTreeItem.getChildren()) {
            this.getJobNodeData(jobHistory, (CommonTableTreeItem)object2, arrayList);
        }
    }

    public ArrayList<String> createNodeCsvHeader() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"run.status"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"return.value"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"session.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"job.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"job.name"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"facility.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"facility.name"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"start.rerun.time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"end.suspend.time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"message"));
        return arrayList;
    }
}

