/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.monitor;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.snmp.bean.SnmpCheckInfo;
import com.clustercontrol.snmp.ejb.session.MonitorSnmpController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.IntegerListComparator;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMonitorSnmpString
extends ExportMonitorString {
    private static Log log = LogFactory.getLog(ExportMonitorSnmpString.class);

    public void exportSnmp() {
        log.info((Object)Messages.getMsg("Snmp.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        ArrayList arrayList3 = this.getSnmpList();
        if (arrayList3 instanceof ArrayList) {
            for (Object object2 : arrayList3) {
                if (object2.getMonitorType() != 2) continue;
                Object[] objectArray = new Object[]{object2.getMonitorId()};
                log.info((Object)Messages.getMsg("MonitorID", objectArray));
                arrayList.add(this.createCsvFormat((MonitorInfo)object2));
                arrayList2.addAll(this.createMonitorJudgement((MonitorInfo)object2));
            }
            Collections.sort(arrayList, new StringListComparator(0));
            Collections.sort(arrayList2, new IntegerListComparator(1));
            Collections.sort(arrayList2, new StringListComparator(0));
        }
        Object object = "";
        if (Config.getConfig("file.timestamp").equalsIgnoreCase("on")) {
            Object object2;
            object2 = new SimpleDateFormat("yyyyMMdd_HHmmss");
            object = "_" + ((DateFormat)object2).format(new Date());
        }
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/SNMP_STR" + (String)object + ".csv", arrayList);
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/SNMP_STR_RULE" + (String)object + ".csv", arrayList2);
        log.info((Object)Messages.getMsg("Snmp.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    @Override
    public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SnmpCheckInfo snmpCheckInfo = monitorInfo.getSnmpCheckInfo();
        if (snmpCheckInfo == null) {
            snmpCheckInfo = new SnmpCheckInfo();
        }
        if (snmpCheckInfo.getCommunityName() != null) {
            arrayList.add(snmpCheckInfo.getCommunityName());
        } else {
            arrayList.add("");
        }
        if (snmpCheckInfo.getSnmpPort() != null) {
            arrayList.add(snmpCheckInfo.getSnmpPort().toString());
        } else {
            arrayList.add("");
        }
        if (snmpCheckInfo.getSnmpOid() != null) {
            arrayList.add(snmpCheckInfo.getSnmpOid());
        } else {
            arrayList.add("");
        }
        if (snmpCheckInfo.getSnmpVersion() != null) {
            arrayList.add(snmpCheckInfo.getSnmpVersion());
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    protected ArrayList getSnmpList() {
        MonitorSnmpController monitorSnmpController = EjbConnectionManager.getConnectionManager().getMonitorSnmpController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorSnmpController.getSnmpList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

