/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.util;

import java.util.ArrayList;


/**
 * 配列を検索するクラス<BR>
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class SelectArrayList {

	/**
	 * 入力配列の指定したインデックスの値が正規表現と一致した要素を出力配列に格納する。<br>
	 * 
	 * @param input 配列
	 * @param index インデックス
	 * @param regex 正規表現
	 * @return 配列
	 */
	public static ArrayList<ArrayList<String>> select(ArrayList<ArrayList<String>> input, int index, String regex){
		ArrayList<ArrayList<String>> output = new ArrayList<ArrayList<String>>();

		for(ArrayList<String> line : input){
			if(index < line.size() && 
					line.get(index) != null && 
					line.get(index).matches(regex))
				output.add(line);
		}

		return output;
	}
}

