/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.monitor;

import java.util.ArrayList;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.ejb.session.SyslogNGController;

/**
 * Syslog-ng監視情報を削除するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class DeleteMonitorSyslogng {

	// ログ出力
	private static Log log = LogFactory.getLog(DeleteMonitorSyslogng.class);

	/**
	 * Syslog-ng監視情報を削除する<br>
	 */
	@SuppressWarnings("unchecked")
	public void delete() {
		log.info(Messages.getMsg("Syslogng.Start", new String[]{Messages.getMsg("ImportTool.Delete")}));

		//監視情報を削除
		deleteMonitorInfo();

		log.info(Messages.getMsg("Syslogng.End", new String[]{Messages.getMsg("ImportTool.Delete")}));
	}

	/**
	 * 監視情報を削除する。<br>
	 */
	protected void deleteMonitorInfo() {
		SyslogNGController syslog = EjbConnectionManager.getConnectionManager().getMonitorSyslogNGController();

		try {
			syslog.createMonitorRuleList(new ArrayList<LogFilterInfo>());
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
	}
}